// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file utility.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief STL utility library
*/

#ifndef NV_STL_UTILITY_HH
#define NV_STL_UTILITY_HH

#include <nv/core/common.hh>
#include <nv/stl/traits/common.hh>

namespace nv
{

	// TODO: change to swap<T> once you get rid of STL
	template< typename T, typename U >
	void swap( T& x, U& y )
	{
		T t = move( x );
		x = move( y );
		y = move( t );
	}

	template < typename T >
	inline const T&	max( const T& a, const T& b )
	{
		return a < b ? b : a;
	}

	template < typename T >
	inline const T&	min( const T& a, const T& b )
	{
		return a > b ? b : a;
	}

}

#endif // NV_STL_UTILITY_HH
