// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file array.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief exception free array classes
 */

#ifndef NV_CORE_ARRAY_HH
#define NV_CORE_ARRAY_HH

#include <nv/core/common.hh>
#include <nv/stl/memory.hh>
#include <nv/stl/iterator.hh>
#include <nv/stl/utility.hh>
#include <vector>
#include <algorithm>
#include <array>

namespace nv
{
	using ::std::vector;

	template < typename ContainerAllocator >
	using array_base = detail::add_random_access< detail::add_iterators < ContainerAllocator > >;


	template< typename T, size_t N >
	using array = array_base < fixed_container_allocator < fixed_static_storage< T, N > > >;
	
	template< typename T >
	using dynamic_array = array_base < sized_container_allocator< resizable_dynamic_storage< T > > >;

// 	template < typename T, typename ContainerAllocator >
// 	class vector_base
// 	{
// 	public:
// 		typedef T         value_type;
// 		typedef size_t    size_type;
// 		typedef ptrdiff_t difference_type;
// 		typedef T*        pointer;
// 		typedef const T*  const_pointer;
// 		typedef T*        iterator;
// 		typedef const T*  const_iterator;
// 		typedef T&        reference;
// 		typedef const T&  const_reference;
// 
// 	protected:
// 		ContainerAllocator m_storage;
// 	};

// 	template< typename T, size_t N >
// 	class static_vector : public detail::pointer_iterators < static_vector< T, N >, T, false >
// 	{
// 	public:
// 		typedef T         value_type;
// 		typedef size_t    size_type;
// 		typedef ptrdiff_t difference_type;
// 		typedef T*        pointer;
// 		typedef const T*  const_pointer;
// 		typedef T*        iterator;
// 		typedef const T*  const_iterator;
// 		typedef T&        reference;
// 		typedef const T&  const_reference;
// 		typedef nv::reverse_iterator<iterator>       reverse_iterator;
// 		typedef nv::reverse_iterator<const_iterator> const_reverse_iterator;
// 
// 		static_vector() : m_size(0) {}
// 
// 		inline const_pointer data() const { return m_data; }
// 		inline pointer data() { return m_data; }
// 		inline size_type size() const { return m_size; }
// 		inline bool empty() const { return !m_size; }
// 		inline size_type   raw_size() const { return N * sizeof( T ); }
// 		inline const char* raw_data() const { return (const char*)m_data; }
// 		inline char*       raw_data() { return (char*)m_data; }
// 
// 		inline reference       front() { NV_ASSERT( !empty(), "front() called on empty data!" );  return m_data[0]; }
// 		inline const_reference front() const { NV_ASSERT( !empty(), "front() called on empty data!" ); return m_data[0]; }
// 		inline reference       back() { NV_ASSERT( !empty(), "front() called on empty data!" ); return m_data[m_size - 1]; }
// 		inline const_reference back() const { NV_ASSERT( !empty(), "front() called on empty data!" ); return m_data[m_size - 1]; }
// 	protected:
// 		value_type m_data[N];
// 		size_type  m_size;
// 	};

}

#endif // NV_CORE_ARRAY_HH