// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file capi.hh
* @author Kornel Kisielewicz
* @brief C API functions
*
* This header is temporary
*/

#ifndef NV_STL_CAPI_HH
#define NV_STL_CAPI_HH

#include <nv/core/common.hh>

#if NV_COMPILER == NV_MSVC
extern "C" {
	NV_NOALIAS NV_RESTRICT void * __cdecl calloc( size_t _Count, size_t _Size );
	NV_NOALIAS             void   __cdecl free( void * _Memory );
	NV_NOALIAS NV_RESTRICT void * __cdecl malloc( size_t );
	NV_NOALIAS NV_RESTRICT void * __cdecl realloc( void * _Memory, size_t _NewSize );
}
#endif 
// TODO: remove when clang 3.5 will be used (with builtins)
#if NV_COMPILER == NV_CLANG
extern "C" {
	extern void * calloc( nv::size_t, nv::size_t );
	extern void   free( void * );
	extern void * malloc( nv::size_t );
	extern void * realloc( void * , nv::size_t );
}
#endif

namespace nv
{
	inline void* nvmalloc( size_t size )
	{
#if NV_COMPILER == NV_MSVC
		return malloc( size );
#elif NV_COMPILER == NV_CLANG
		return malloc( size );
		//		return __builtin_operator_new( size );
#else
		return __builtin_malloc( size );
#endif
	}
	inline void nvfree( void* p )
	{
#if NV_COMPILER == NV_MSVC
		free( p );
#elif NV_COMPILER == NV_CLANG
		free( p );
		//		__builtin_operator_delete( p );
#else
		__builtin_free( p );
#endif
	}

}

#endif // NV_STL_CAPI_HH
