// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lua/lua_handle.hh"

#include "nv/lua/lua_state.hh"
#include "nv/lua/lua_raw.hh"

// pseudoindex must be valid
void nv::lua::detail::push_handle_impl( lua_State* L, int pseudoindex, uint32 index )
{
	NV_LUA_STACK_ASSERT( L, +1 );
	lua_rawgeti( L, LUA_REGISTRYINDEX, pseudoindex ); // table
	lua_rawgeti( L, -1, (int)index );                 // table, entry
	if ( !lua_istable( L, -1 ) )
	{
		NV_LOG( nv::LOG_ERROR, "NIL" );
		lua_pop( L, 2 );
		lua_pushnil( L );
		return;
	}
	lua_replace( L, -2 );
}

nv::lua::detail::handle_struct nv::lua::detail::to_handle_impl( lua_State* L, int i, uint32 dindex, uint32 dcounter )
{
	NV_LUA_STACK_ASSERT( L, 0 );
	handle_conversion hc;
	hc.h.index   = dindex;
	hc.h.counter = dcounter;
	if ( lua_istable( L, i ) )
	{
		lua_rawgeti( L, i, 1 ); // handle as double
		hc.d = lua_tonumber( L, -1 );
		lua_pop( L, 1 );
	}
	return hc.h;
}

void nv::lua::detail::register_handle_impl( lua_State* L, int pseudoindex, uint32 index, uint32 counter, bool empty )
{
	if ( empty )
	{
		lua_newtable( L );
	}
	if ( !lua_istable( L, -1 ) ) return;

	handle_conversion hc;
	hc.h.index   = index;
	hc.h.counter = counter;
	lua_pushnumber( L, hc.d );
	lua_rawseti( L, -2, 1 );

	lua_rawgeti( L, LUA_REGISTRYINDEX, pseudoindex );
	lua_insert( L, -2 );
	lua_rawseti( L, -2, (int)index );
	lua_pop( L, 1 );
}

void nv::lua::detail::unregister_handle_impl( lua_State* L, int pseudoindex, uint32 index )
{
	NV_LUA_STACK_ASSERT( L, 0 );
	lua_rawgeti( L, LUA_REGISTRYINDEX, pseudoindex ); // table
	lua_pushinteger( L, 0 );
	lua_rawseti( L, -2, (int)index );
	lua_pop( L, 1 );
}
