// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_enum.hh"

#include "nv/lib/gl.hh"

using namespace nv;

unsigned int clear_state_buffers_to_mask( clear_state::buffers_type type )
{
	unsigned int mask = 0;
	if ( (type & clear_state::COLOR_BUFFER) != 0 )   mask |= GL_COLOR_BUFFER_BIT;
	if ( (type & clear_state::DEPTH_BUFFER) != 0 )   mask |= GL_DEPTH_BUFFER_BIT;
	if ( (type & clear_state::STENCIL_BUFFER) != 0 ) mask |= GL_STENCIL_BUFFER_BIT;
	return mask;
}

unsigned int depth_state_function_to_enum( depth_test::function_type type )
{
	switch( type )
	{
	case depth_test::NEVER            : return GL_NEVER;
	case depth_test::LESS             : return GL_LESS;
	case depth_test::EQUAL            : return GL_EQUAL;
	case depth_test::LESS_OR_EQUAL    : return GL_LEQUAL;
	case depth_test::GREATER          : return GL_GREATER;
	case depth_test::NOT_EQUAL        : return GL_NOTEQUAL;
	case depth_test::GREATER_OR_EQUAL : return GL_GEQUAL;
	case depth_test::ALWAYS           : return GL_ALWAYS;
	default : return 0; // TODO: throw!
	}
}

unsigned int blending_factor_to_enum( blending::factor type )
{
	switch( type )
	{
	case blending::ZERO                    : return GL_ZERO;
	case blending::ONE                     : return GL_ONE;
	case blending::SRC_COLOR               : return GL_SRC_COLOR;
	case blending::ONE_MINUS_SRC_COLOR     : return GL_ONE_MINUS_SRC_COLOR;
	case blending::DST_COLOR               : return GL_DST_COLOR;
	case blending::ONE_MINUS_DST_COLOR     : return GL_ONE_MINUS_DST_COLOR;
	case blending::SRC_ALPHA               : return GL_SRC_ALPHA;
	case blending::ONE_MINUS_SRC_ALPHA     : return GL_ONE_MINUS_SRC_ALPHA;
	case blending::DST_ALPHA               : return GL_DST_ALPHA;
	case blending::ONE_MINUS_DST_ALPHA     : return GL_ONE_MINUS_DST_ALPHA;
	case blending::CONSTANT_COLOR          : return GL_CONSTANT_COLOR;
	case blending::ONE_MINUS_CONSTANT_COLOR: return GL_ONE_MINUS_CONSTANT_COLOR;
	case blending::CONSTANT_ALPHA          : return GL_CONSTANT_ALPHA;
	case blending::ONE_MINUS_CONSTANT_ALPHA: return GL_ONE_MINUS_CONSTANT_ALPHA;
	case blending::SRC_ALPHA_SATURATE      : return GL_SRC_ALPHA_SATURATE;
	default : return 0; // TODO: throw!
	}
}

unsigned int blending_equation_to_enum( blending::equation type )
{
	switch( type )
	{
	case blending::ADD              : return GL_FUNC_ADD;
	case blending::SUBTRACT         : return GL_FUNC_SUBTRACT;
	case blending::REVERSE_SUBTRACT : return GL_FUNC_REVERSE_SUBTRACT;
	case blending::MINIMUM          : return GL_MIN;
	case blending::MAXIMUM          : return GL_MAX;
	default : return 0; // TODO: throw!
	}
}

unsigned int culling_face_type_to_enum( culling::face_type type )
{
	switch( type )
	{
	case culling::FRONT          : return GL_FRONT;
	case culling::BACK           : return GL_BACK;
	case culling::FRONT_AND_BACK : return GL_FRONT_AND_BACK;
	default : return 0; // TODO: throw!
	}
}

unsigned int culling_order_type_to_enum( culling::order_type type )
{
	switch( type )
	{
	case culling::CW   : return GL_CW;
	case culling::CCW  : return GL_CCW;
	default : return 0; // TODO: throw!
	}
}

unsigned int stencil_function_to_enum( stencil_test_face::function_type type )
{
	switch( type )
	{
	case stencil_test_face::NEVER            : return GL_NEVER;
	case stencil_test_face::LESS             : return GL_LESS;
	case stencil_test_face::EQUAL            : return GL_EQUAL;
	case stencil_test_face::LESS_OR_EQUAL    : return GL_LEQUAL;
	case stencil_test_face::GREATER          : return GL_GREATER;
	case stencil_test_face::NOT_EQUAL        : return GL_NOTEQUAL;
	case stencil_test_face::GREATER_OR_EQUAL : return GL_GEQUAL;
	case stencil_test_face::ALWAYS           : return GL_ALWAYS;
	default : return 0; // TODO: throw!
	}
}

unsigned int stencil_operation_to_enum( stencil_test_face::operation type )
{
	switch( type )
	{
	case stencil_test_face::ZERO             : return GL_ZERO;
	case stencil_test_face::INVERT           : return GL_INVERT;
	case stencil_test_face::KEEP             : return GL_KEEP;
	case stencil_test_face::REPLACE          : return GL_REPLACE;
	case stencil_test_face::INCREMENT        : return GL_INCR;
	case stencil_test_face::DECREMENT        : return GL_DECR;
	case stencil_test_face::INCREMENT_WRAP   : return GL_INCR_WRAP;
	case stencil_test_face::DECREMENT_WRAP   : return GL_DECR_WRAP;
	default : return 0; // TODO: throw!
	}
}

unsigned int type_to_gl_enum( type type )
{
	switch( type )
	{
	case FLOAT          : return GL_FLOAT;
	case FLOAT_VECTOR_2 : return GL_FLOAT_VEC2;
	case FLOAT_VECTOR_3 : return GL_FLOAT_VEC3;
	case FLOAT_VECTOR_4 : return GL_FLOAT_VEC4;
	case FLOAT_MATRIX_2 : return GL_FLOAT_MAT2;
	case FLOAT_MATRIX_3 : return GL_FLOAT_MAT3;
	case FLOAT_MATRIX_4 : return GL_FLOAT_MAT4;
	case INT            : return GL_INT;
	case INT_VECTOR_2   : return GL_INT_VEC2;
	case INT_VECTOR_3   : return GL_INT_VEC3;
	case INT_VECTOR_4   : return GL_INT_VEC4;
	default : return 0; // TODO: throw!
	}
}

nv::type gl_enum_to_type( unsigned int gl_enum )
{
	switch( gl_enum )
	{
	case GL_FLOAT      : return FLOAT;
	case GL_FLOAT_VEC2 : return FLOAT_VECTOR_2;
	case GL_FLOAT_VEC3 : return FLOAT_VECTOR_3;
	case GL_FLOAT_VEC4 : return FLOAT_VECTOR_4;
	case GL_FLOAT_MAT2 : return FLOAT_MATRIX_2;
	case GL_FLOAT_MAT3 : return FLOAT_MATRIX_3;
	case GL_FLOAT_MAT4 : return FLOAT_MATRIX_4;
	case GL_INT        : return INT;
	case GL_INT_VEC2   : return INT_VECTOR_2;
	case GL_INT_VEC3   : return INT_VECTOR_3;
	case GL_INT_VEC4   : return INT_VECTOR_4;
	default : return type(0); // TODO: throw!
	}
}
