// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lua/lua_path.hh"

#include "nv/lua/lua_raw.hh"

using namespace nv;

void lua::path::parse()
{
	if ( m_elements[0].length == 0 || m_elements[0].str == nullptr ) return;
	string_ref spath( m_elements[0].str, m_elements[0].length );
	m_count = 0;
	size_t point = spath.find( '.' );

	while ( point != std::string::npos )
	{
		m_elements[m_count].str    = spath.data();
		m_elements[m_count].length = point;
		m_count++;
		spath.remove_prefix( point + 1 );
		point = spath.find( '.' );
	}

	m_elements[m_count].str    = spath.data();
	m_elements[m_count].length = spath.length();
	m_count++;
}

void lua::path::push( size_t value )
{
	m_elements[ m_count ].value  = value;
	m_elements[ m_count ].length = 0;
	m_count++;
}

void nv::lua::path::push( string_ref p )
{
	m_elements[ m_count ].str    = p.data();
	m_elements[ m_count ].length = p.length();
	m_count++;
}

bool lua::path::resolve( lua_State* L, bool global /*= true */ ) const
{
	if (m_count == 0) return false;
	if (global) lua_pushglobaltable( L );
	for (int i = 0; i < m_count; ++i )
	{
		if ( lua_istable( L, -1 ) )
		{
			if ( m_elements[i].length > 0 )
			{
				lua_pushlstring( L, m_elements[i].str, m_elements[i].length );
			}
			else
			{
				lua_pushunsigned( L, m_elements[i].value );
			}
			lua_gettable( L, -2 );
			if (i > 0 || global ) lua_replace( L, -2 );
		}
		else
		{
			lua_pop(L, 1);
			return false;
		}
	}
	return true;
}

std::string nv::lua::path::to_string() const
{
	std::string result;
	result.reserve( 64 );
	bool dot = false;
	for ( const element& e : m_elements )
	{
		if ( dot ) result.append(".");
		if ( e.length == 0 )
		{
			result.append("[" + nv::to_string( e.value ) + "]" );
			dot = false;
		}
		else
		{
			result.append( e.str, e.length );
			dot = true;
		}
	}
	return result;
}
