// Copyright (C) 2014 ChaosForge Ltd
// This file is part of Nova Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/sdl/sdl_window.hh"

#include "nv/core/logging.hh"
#include "nv/lib/gl.hh"
#include "nv/lib/sdl.hh"
#include "nv/sdl/sdl_input.hh"

using namespace nv;

sdl::window::window( device* dev, uint16 width, uint16 height, bool fullscreen )
	: m_device( dev ), m_width( width ), m_height( height ), m_title("Nova Engine"), m_handle( nullptr )
{
	m_input = new sdl::input();
	//	bpp = m_info->vfmt->BitsPerPixel;

	SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 8 );
	SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 8 );
	SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 8 );
	SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 24 );
	SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );

	//	SDL_GL_SetAttribute( SDL_GL_MULTISAMPLEBUFFERS, 1 );
	//	SDL_GL_SetAttribute( SDL_GL_MULTISAMPLESAMPLES, 4 );

	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 2);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 1);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);

	uint32 flags = SDL_WINDOW_OPENGL | SDL_WINDOW_SHOWN;
	if (fullscreen) flags |= SDL_WINDOW_FULLSCREEN;
	m_title  = "Nova Engine";
	m_handle = SDL_CreateWindow( m_title.c_str(), SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
		width, height, flags );
	if ( m_handle == 0 )
	{
		NV_LOG( LOG_CRITICAL, "Video mode set failed: " << SDL_GetError( ) );
		return; // TODO: Error report
	}

	// 	NV_LOG( LOG_INFO, "Joystick count : " << SDL_NumJoysticks() );
	// 	SDL_Joystick* j = SDL_JoystickOpen(0);
	// 	if (j)
	// 	{
	// 		NV_LOG( LOG_INFO, "Joystick Name: " << SDL_JoystickNameForIndex(0) );
	// 		NV_LOG( LOG_INFO, "Joystick Number of Axes: " << SDL_JoystickNumAxes(j));
	// 		NV_LOG( LOG_INFO, "Joystick Number of Buttons: " << SDL_JoystickNumButtons(j));
	// 		NV_LOG( LOG_INFO, "Joystick Number of Balls: " << SDL_JoystickNumBalls(j));
	// 	}

	void* ctx_handle = SDL_GL_CreateContext( static_cast<SDL_Window*>( m_handle ) );

	if ( ctx_handle == 0 )
	{
		NV_LOG( LOG_CRITICAL, "GL Context creation failed: " << SDL_GetError( ) );
		return; // TODO: Error report
	}

	nv::load_gl_library();
	NV_LOG( LOG_INFO, "OpenGL Vendor       : " << glGetString(GL_VENDOR) );
	NV_LOG( LOG_INFO, "OpenGL Renderer     : " << glGetString(GL_RENDERER) );
	NV_LOG( LOG_INFO, "OpenGL Version      : " << glGetString(GL_VERSION) );
	NV_LOG( LOG_INFO, "OpenGL GLSL Version : " << glGetString(GL_SHADING_LANGUAGE_VERSION) );
	// SDL_GL_SetSwapInterval(1);

	// TODO: do we really need this?
	glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );

	m_context = new gl_context( m_device, ctx_handle );
	m_context->set_viewport( nv::ivec4( 0, 0, m_width, m_height ) );
}

void sdl::window::set_title( const string& title )
{
	SDL_SetWindowTitle( static_cast<SDL_Window*>( m_handle ), title.c_str() );
	m_title = title;
}

void sdl::window::swap_buffers()
{
	SDL_GL_SwapWindow( static_cast<SDL_Window*>( m_handle ) );
}

sdl::window::~window()
{
	delete m_input;
	if ( m_context )
	{
		SDL_GLContext native = static_cast<SDL_GLContext>( m_context->get_native_handle() );
		delete m_context;
		SDL_GL_DeleteContext( native );
	}
	m_context = nullptr;
	SDL_DestroyWindow( static_cast<SDL_Window*>( m_handle ) );
}
