// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/sdl/sdl_audio.hh"

#include "nv/lib/sdl.hh"
#include "nv/lib/sdl_mixer.hh"
#include "nv/core/logging.hh"

using namespace nv;

sdl::audio::audio()
{
	nv::load_sdl_library();
	nv::load_sdl_mixer_library();

	if ( SDL_Init( SDL_INIT_AUDIO ) == -1 ) 
	{
		NV_LOG( LOG_CRITICAL, "SDL_AUDIO failed to load -- " << SDL_GetError() );
		return;
	}

	if( Mix_OpenAudio( 44100, MIX_DEFAULT_FORMAT, 2, 1024 ) == -1 )
	{
		NV_LOG( LOG_CRITICAL, "SDL_mixer failed to load -- " << Mix_GetError() );
		return;
	}
}


nv::channel sdl::audio::play_sound( sound a_sound )
{
	sound_info* info = m_sounds.get( a_sound );
	if ( info )
	{
		if ( Mix_PlayChannel(-1, (Mix_Chunk*)( info->sdl_sound), 0) == -1 )
		{
			NV_LOG( LOG_WARNING, "SDL_mixer failed to play -- " << Mix_GetError() );
		}
	}
	return channel();
}

nv::sound nv::sdl::audio::load_sound( const std::string& a_path )
{
	// TODO: this is a really wierd error - if we remove this check, all hell gets loose
	if ( Mix_LoadWAV_RW == nullptr || SDL_RWFromFile == nullptr ) 
	{
		NV_LOG( LOG_ERROR, "SDL_mixer not loaded!" );
	}
	Mix_Chunk *sample = Mix_LoadWAV_RW(SDL_RWFromFile(a_path.c_str(), "rb"), 1);
	if ( sample == nullptr )
	{
		NV_LOG( LOG_ERROR, "SDL_mixer failed to load sample '" << a_path << "' -- " << Mix_GetError() );
		return sound();
	}
	sound result = m_sounds.create();
	sound_info* info = m_sounds.get( result );
	info->sdl_sound = sample;
	return result;
}

void nv::sdl::audio::update()
{
	// no-op
}

nv::sdl::audio::~audio()
{
	while ( m_sounds.size() > 0 )
		release( m_sounds.get_handle(0) );
	Mix_CloseAudio();
	// TODO: should we do it here?
	SDL_Quit();
}

void nv::sdl::audio::release( sound a_sound )
{
	sound_info* info = m_sounds.get( a_sound );
	if ( info )
	{
		Mix_FreeChunk( (Mix_Chunk*)info->sdl_sound );
		m_sounds.destroy( a_sound );
	}
}

