// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file sdl_audio.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief SDL Audio interface 
 */

#ifndef NV_SDL_AUDIO_HH
#define NV_SDL_AUDIO_HH

#include <nv/core/common.hh>
#include <nv/interface/audio.hh>

namespace nv
{

	namespace sdl
	{
		struct sound_info
		{
			void* sdl_sound;
		};

		class audio : public nv::audio
		{
		public:
			audio();
			virtual channel play_sound( sound a_sound );
			virtual sound load_sound( const std::string& a_path );
			virtual void release( sound a_sound );
			virtual void update();
			virtual ~audio();
		private:
			entity_store< sound_info, sound >     m_sounds;
		};
	}
}

#endif // NV_SDL_AUDIO_HH
