// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file fmod_audio.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief FMOD Audio interface 
 */

#ifndef NV_FMOD_AUDIO_HH
#define NV_FMOD_AUDIO_HH

#include <nv/core/common.hh>
#include <nv/interface/audio.hh>

namespace nv
{

	namespace fmod
	{
		class audio;

		struct sound_info
		{
			void* fmod_sound;
		};

		class audio : public nv::audio
		{
		public:
			audio();
			virtual channel play_sound( sound a_sound );
			virtual sound load_sound( const std::string& a_path );
			virtual void release( sound a_sound );
			virtual void update();
			virtual ~audio();
		private:
			entity_store< sound_info, sound >     m_sounds;
			void* m_system;
		};
	}
}

#endif // NV_FMOD_AUDIO_HH
