// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_device.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Device class
 */

#ifndef NV_GL_DEVICE_HH
#define NV_GL_DEVICE_HH

#include <nv/interface/device.hh>

namespace nv
{
	struct gl_texture_info : public texture_info
	{
		unsigned glid;
	};

	struct gl_buffer_info : public buffer_info
	{
		unsigned glid;
	};

	struct gl_program_info : public program_info
	{
		unsigned glid;
		unsigned glidv;
		unsigned glidf;
	};

	class gl_device : public device
	{
	public:
		friend class gl_context;

		gl_device();
		virtual image_data* create_image_data( const std::string& filename ); // temporary

		virtual program create_program( const string& vs_source, const string& fs_source );
		virtual buffer create_buffer( buffer_type type, buffer_hint hint, size_t size, const void* source = nullptr );
		virtual texture create_texture( ivec2 size, image_format aformat, sampler asampler, void* data = nullptr );

		virtual void release( buffer b );
		virtual void release( texture t );
		virtual void release( program p );
		virtual const texture_info* get_texture_info( texture t ) const;
		virtual const buffer_info* get_buffer_info( buffer t ) const;

		virtual int get_attribute_location( program p, const string& name, bool fatal = true ) const;
		virtual void prepare_program( program p );
		virtual const string& get_shader_header() const { return m_shader_header; }
		virtual ~gl_device();
	protected:
		uniform_base* get_uniform( program p, const string& name, bool fatal = true ) const;

	
	private:
		bool compile( gl_program_info* p, const string& vertex_program, const string& fragment_program );
		void update_uniforms( gl_program_info* p );
		void load_attributes( gl_program_info* p );
		void load_uniforms( gl_program_info* p );
		bool compile( uint32 sh_type, const std::string& shader_code, unsigned& glid );
		std::string m_shader_header;
		entity_store< gl_texture_info, texture >         m_textures;
		entity_store< gl_buffer_info,  buffer >          m_buffers;
		entity_store< gl_program_info, program >         m_programs;
	};

} // namespace nv


#endif // NV_GL_DEVICE_HH
