#define CURSES_PDC_BUILD 3401
#define CURSES_PDCURSES        1
#define CURSES_XOPEN           1
#define CURSES_SYSVcurses      1
#define CURSES_BSDcurses       1
#define CURSES_CHTYPE_LONG     1

#ifndef CURSES_FALSE
# define CURSES_FALSE 0
#endif
#ifndef CURSES_TRUE
# define CURSES_TRUE 1
#endif
#ifndef CURSES_NULL
# define CURSES_NULL (void *)0
#endif
#ifndef CURSES_ERR
# define CURSES_ERR (-1)
#endif
#ifndef CURSES_OK
# define CURSES_OK 0
#endif

typedef unsigned char BOOL;

#ifdef CURSES_CHTYPE_LONG
# ifdef _LP64
# if _LP64
typedef unsigned int chtype;
# else
typedef unsigned long chtype;  /* 16-bit attr + 16-bit char */
# endif
# else
typedef unsigned long chtype;  /* 16-bit attr + 16-bit char */
# endif
#else
typedef unsigned short chtype; /* 8-bit attr + 8-bit char */
#endif

#ifdef CURSES_PDC_WIDE
typedef chtype cchar_t;
#endif

typedef chtype attr_t;

typedef struct
{
    int x;           /* absolute column, 0 based, measured in characters */
    int y;           /* absolute row, 0 based, measured in characters */
    short button[3]; /* state of each button */
    int changes;     /* flags indicating what has changed with the mouse */
} MOUSE_STATUS;

#define CURSES_BUTTON_RELEASED         0x0000
#define CURSES_BUTTON_PRESSED          0x0001
#define CURSES_BUTTON_CLICKED          0x0002
#define CURSES_BUTTON_DOUBLE_CLICKED   0x0003
#define CURSES_BUTTON_TRIPLE_CLICKED   0x0004
#define CURSES_BUTTON_MOVED            0x0005  /* PDCurses */
#define CURSES_WHEEL_SCROLLED          0x0006  /* PDCurses */
#define CURSES_BUTTON_ACTION_MASK      0x0007  /* PDCurses */

#define CURSES_PDC_BUTTON_SHIFT        0x0008  /* PDCurses */
#define CURSES_PDC_BUTTON_CONTROL      0x0010  /* PDCurses */
#define CURSES_PDC_BUTTON_ALT          0x0020  /* PDCurses */
#define CURSES_BUTTON_MODIFIER_MASK    0x0038  /* PDCurses */

#define CURSES_MOUSE_X_POS             (Mouse_status.x)
#define CURSES_MOUSE_Y_POS             (Mouse_status.y)

/*
 * Bits associated with the .changes field:
 *   3         2         1         0
 * 210987654321098765432109876543210
 *                                 1 <- button 1 has changed
 *                                10 <- button 2 has changed
 *                               100 <- button 3 has changed
 *                              1000 <- mouse has moved
 *                             10000 <- mouse position report
 *                            100000 <- mouse wheel up
 *                           1000000 <- mouse wheel down
 */

#define CURSES_PDC_MOUSE_MOVED         0x0008
#define CURSES_PDC_MOUSE_POSITION      0x0010
#define CURSES_PDC_MOUSE_WHEEL_UP      0x0020
#define CURSES_PDC_MOUSE_WHEEL_DOWN    0x0040

#define CURSES_A_BUTTON_CHANGED        (Mouse_status.changes & 7)
#define CURSES_MOUSE_MOVED             (Mouse_status.changes & PDC_MOUSE_MOVED)
#define CURSES_MOUSE_POS_REPORT        (Mouse_status.changes & PDC_MOUSE_POSITION)
#define CURSES_BUTTON_CHANGED(x)       (Mouse_status.changes & (1 << ((x) - 1)))
#define CURSES_BUTTON_STATUS(x)        (Mouse_status.button[(x) - 1])
#define CURSES_MOUSE_WHEEL_UP          (Mouse_status.changes & PDC_MOUSE_WHEEL_UP)
#define CURSES_MOUSE_WHEEL_DOWN        (Mouse_status.changes & PDC_MOUSE_WHEEL_DOWN)

/* mouse bit-masks */

#define CURSES_BUTTON1_RELEASED        0x00000001L
#define CURSES_BUTTON1_PRESSED         0x00000002L
#define CURSES_BUTTON1_CLICKED         0x00000004L
#define CURSES_BUTTON1_DOUBLE_CLICKED  0x00000008L
#define CURSES_BUTTON1_TRIPLE_CLICKED  0x00000010L
#define CURSES_BUTTON1_MOVED           0x00000010L /* PDCurses */

#define CURSES_BUTTON2_RELEASED        0x00000020L
#define CURSES_BUTTON2_PRESSED         0x00000040L
#define CURSES_BUTTON2_CLICKED         0x00000080L
#define CURSES_BUTTON2_DOUBLE_CLICKED  0x00000100L
#define CURSES_BUTTON2_TRIPLE_CLICKED  0x00000200L
#define CURSES_BUTTON2_MOVED           0x00000200L /* PDCurses */

#define CURSES_BUTTON3_RELEASED        0x00000400L
#define CURSES_BUTTON3_PRESSED         0x00000800L
#define CURSES_BUTTON3_CLICKED         0x00001000L
#define CURSES_BUTTON3_DOUBLE_CLICKED  0x00002000L
#define CURSES_BUTTON3_TRIPLE_CLICKED  0x00004000L
#define CURSES_BUTTON3_MOVED           0x00004000L /* PDCurses */

#define CURSES_BUTTON4_RELEASED        0x00008000L
#define CURSES_BUTTON4_PRESSED         0x00010000L
#define CURSES_BUTTON4_CLICKED         0x00020000L
#define CURSES_BUTTON4_DOUBLE_CLICKED  0x00040000L
#define CURSES_BUTTON4_TRIPLE_CLICKED  0x00080000L

#define CURSES_BUTTON5_RELEASED        0x00100000L
#define CURSES_BUTTON5_PRESSED         0x00200000L
#define CURSES_BUTTON5_CLICKED         0x00400000L
#define CURSES_BUTTON5_DOUBLE_CLICKED  0x00800000L
#define CURSES_BUTTON5_TRIPLE_CLICKED  0x01000000L

#define CURSES_MOUSE_WHEEL_SCROLL      0x02000000L /* PDCurses */
#define CURSES_BUTTON_MODIFIER_SHIFT   0x04000000L /* PDCurses */
#define CURSES_BUTTON_MODIFIER_CONTROL 0x08000000L /* PDCurses */
#define CURSES_BUTTON_MODIFIER_ALT     0x10000000L /* PDCurses */

#define CURSES_ALL_MOUSE_EVENTS        0x1fffffffL
#define CURSES_REPORT_MOUSE_POSITION   0x20000000L

/* ncurses mouse interface */

typedef unsigned long mmask_t;

typedef struct
{
        short id;       /* unused, always 0 */
        int x, y, z;    /* x, y same as MOUSE_STATUS; z unused */
        mmask_t bstate; /* equivalent to changes + button[], but
                           in the same format as used for mousemask() */
} MEVENT;

#ifdef CURSES_NCURSES_MOUSE_VERSION
# define CURSES_BUTTON_SHIFT   CURSES_BUTTON_MODIFIER_SHIFT
# define CURSES_BUTTON_CONTROL CURSES_BUTTON_MODIFIER_CONTROL
# define CURSES_BUTTON_CTRL    CURSES_BUTTON_MODIFIER_CONTROL
# define CURSES_BUTTON_ALT     CURSES_BUTTON_MODIFIER_ALT
#else
# define CURSES_BUTTON_SHIFT   CURSES_PDC_BUTTON_SHIFT
# define CURSES_BUTTON_CONTROL CURSES_PDC_BUTTON_CONTROL
# define CURSES_BUTTON_ALT     CURSES_PDC_BUTTON_ALT
#endif

typedef struct _win       /* definition of a window */
{
    int   _cury;          /* current pseudo-cursor */
    int   _curx;
    int   _maxy;          /* max window coordinates */
    int   _maxx;
    int   _begy;          /* origin on screen */
    int   _begx;
    int   _flags;         /* window properties */
    chtype _attrs;        /* standard attributes and colors */
    chtype _bkgd;         /* background, normally blank */
    BOOL  _clear;         /* causes clear at next refresh */
    BOOL  _leaveit;       /* leaves cursor where it is */
    BOOL  _scroll;        /* allows window scrolling */
    BOOL  _nodelay;       /* input character wait flag */
    BOOL  _immed;         /* immediate update flag */
    BOOL  _sync;          /* synchronise window ancestors */
    BOOL  _use_keypad;    /* flags keypad key mode active */
    chtype **_y;          /* pointer to line pointer array */
    int   *_firstch;      /* first changed character in line */
    int   *_lastch;       /* last changed character in line */
    int   _tmarg;         /* top of scrolling region */
    int   _bmarg;         /* bottom of scrolling region */
    int   _delayms;       /* milliseconds of delay for getch() */
    int   _parx, _pary;   /* coords relative to parent (0,0) */
    struct _win *_parent; /* subwin's pointer to parent win */
} WINDOW;

typedef struct
{
    BOOL  alive;          /* if initscr() called, and not endwin() */
    BOOL  autocr;         /* if cr -> lf */
    BOOL  cbreak;         /* if terminal unbuffered */
    BOOL  echo;           /* if terminal echo */
    BOOL  raw_inp;        /* raw input mode (v. cooked input) */
    BOOL  raw_out;        /* raw output mode (7 v. 8 bits) */
    BOOL  audible;        /* FALSE if the bell is visual */
    BOOL  mono;           /* TRUE if current screen is mono */
    BOOL  resized;        /* TRUE if TERM has been resized */
    BOOL  orig_attr;      /* TRUE if we have the original colors */
    short orig_fore;      /* original screen foreground color */
    short orig_back;      /* original screen foreground color */
    int   cursrow;        /* position of physical cursor */
    int   curscol;        /* position of physical cursor */
    int   visibility;     /* visibility of cursor */
    int   orig_cursor;    /* original cursor size */
    int   lines;          /* new value for LINES */
    int   cols;           /* new value for COLS */
    unsigned long _trap_mbe;       /* trap these mouse button events */
    unsigned long _map_mbe_to_key; /* map mouse buttons to slk */
    int   mouse_wait;              /* time to wait (in ms) for a
                                      button release after a press, in 
                                      order to count it as a click */
    int   slklines;                /* lines in use by slk_init() */
    WINDOW *slk_winptr;            /* window for slk */
    int   linesrippedoff;          /* lines ripped off via ripoffline() */
    int   linesrippedoffontop;     /* lines ripped off on 
                                      top via ripoffline() */
    int   delaytenths;             /* 1/10ths second to wait block
                                      getch() for */
    BOOL  _preserve;               /* TRUE if screen background
                                      to be preserved */
    int   _restore;                /* specifies if screen background
                                      to be restored, and how */
    BOOL  save_key_modifiers;      /* TRUE if each key modifiers saved
                                      with each key press */
    BOOL  return_key_modifiers;    /* TRUE if modifier keys are
                                      returned as "real" keys */
    BOOL  key_code;                /* TRUE if last key is a special key;
                                      used internally by get_wch() */
#ifdef CURSES_XCURSES
    int   XcurscrSize;    /* size of Xcurscr shared memory block */
    BOOL  sb_on;
    int   sb_viewport_y;
    int   sb_viewport_x;
    int   sb_total_y;
    int   sb_total_x;
    int   sb_cur_y;
    int   sb_cur_x;
#endif
    short line_color;     /* color of line attributes - default -1 */
} SCREEN;

NV_CURSES_API int          LINES;        /* terminal height */
NV_CURSES_API int          COLS;         /* terminal width */
NV_CURSES_API WINDOW       *stdscr;      /* the default screen window */
NV_CURSES_API WINDOW       *curscr;      /* the current screen image */
NV_CURSES_API SCREEN       *SP;          /* curses variables */
NV_CURSES_API MOUSE_STATUS Mouse_status;
NV_CURSES_API int          COLORS;
NV_CURSES_API int          COLOR_PAIRS;
NV_CURSES_API int          TABSIZE;
NV_CURSES_API chtype       acs_map[];    /* alternate character set map */
NV_CURSES_API char         ttytype[];    /* terminal name/description */

#define CURSES_A_NORMAL      (chtype)0

#ifdef CURSES_CHTYPE_LONG
# define CURSES_A_ALTCHARSET (chtype)0x00010000
# define CURSES_A_RIGHTLINE  (chtype)0x00020000
# define CURSES_A_LEFTLINE   (chtype)0x00040000
# define CURSES_A_INVIS      (chtype)0x00080000
# define CURSES_A_UNDERLINE  (chtype)0x00100000
# define CURSES_A_REVERSE    (chtype)0x00200000
# define CURSES_A_BLINK      (chtype)0x00400000
# define CURSES_A_BOLD       (chtype)0x00800000

# define CURSES_A_ATTRIBUTES (chtype)0xffff0000
# define CURSES_A_CHARTEXT   (chtype)0x0000ffff
# define CURSES_A_COLOR      (chtype)0xff000000

# define CURSES_A_ITALIC     CURSES_A_INVIS
# define CURSES_A_PROTECT    (CURSES_A_UNDERLINE | CURSES_A_LEFTLINE | CURSES_A_RIGHTLINE)

# define CURSES_PDC_ATTR_SHIFT  19
# define CURSES_PDC_COLOR_SHIFT 24
#else
# define CURSES_A_BOLD       (chtype)0x0100  /* X/Open */
# define CURSES_A_REVERSE    (chtype)0x0200  /* X/Open */
# define CURSES_A_BLINK      (chtype)0x0400  /* X/Open */

# define CURSES_A_ATTRIBUTES (chtype)0xff00  /* X/Open */
# define CURSES_A_CHARTEXT   (chtype)0x00ff  /* X/Open */
# define CURSES_A_COLOR      (chtype)0xf800  /* System V */

# define CURSES_A_ALTCHARSET CURSES_A_NORMAL        /* X/Open */
# define CURSES_A_PROTECT    CURSES_A_NORMAL        /* X/Open */
# define CURSES_A_UNDERLINE  CURSES_A_NORMAL        /* X/Open */

# define CURSES_A_LEFTLINE   CURSES_A_NORMAL
# define CURSES_A_RIGHTLINE  CURSES_A_NORMAL
# define CURSES_A_ITALIC     CURSES_A_NORMAL
# define CURSES_A_INVIS      CURSES_A_NORMAL

# define CURSES_PDC_ATTR_SHIFT   8
# define CURSES_PDC_COLOR_SHIFT 11
#endif

#define CURSES_A_STANDOUT    (CURSES_A_REVERSE | CURSES_A_BOLD) /* X/Open */
#define CURSES_A_DIM         CURSES_A_NORMAL

#define CURSES_CHR_MSK       CURSES_A_CHARTEXT           /* Obsolete */
#define CURSES_ATR_MSK       CURSES_A_ATTRIBUTES         /* Obsolete */
#define CURSES_ATR_NRM       CURSES_A_NORMAL             /* Obsolete */

#define CURSES_WA_ALTCHARSET CURSES_A_ALTCHARSET
#define CURSES_WA_BLINK      CURSES_A_BLINK
#define CURSES_WA_BOLD       CURSES_A_BOLD
#define CURSES_WA_DIM        CURSES_A_DIM
#define CURSES_WA_INVIS      CURSES_A_INVIS
#define CURSES_WA_LEFT       CURSES_A_LEFTLINE
#define CURSES_WA_PROTECT    CURSES_A_PROTECT
#define CURSES_WA_REVERSE    CURSES_A_REVERSE
#define CURSES_WA_RIGHT      CURSES_A_RIGHTLINE
#define CURSES_WA_STANDOUT   CURSES_A_STANDOUT
#define CURSES_WA_UNDERLINE  CURSES_A_UNDERLINE

#define CURSES_WA_HORIZONTAL CURSES_A_NORMAL
#define CURSES_WA_LOW        CURSES_A_NORMAL
#define CURSES_WA_TOP        CURSES_A_NORMAL
#define CURSES_WA_VERTICAL   CURSES_A_NORMAL

#ifdef CURSES_CHTYPE_LONG
# define CURSES_ACS_PICK(w, n) ((chtype)w | CURSES_A_ALTCHARSET)
#else
# define CURSES_ACS_PICK(w, n) ((chtype)n)
#endif

#define CURSES_ACS_ULCORNER  CURSES_ACS_PICK('l', '+')
#define CURSES_ACS_LLCORNER  CURSES_ACS_PICK('m', '+')
#define CURSES_ACS_URCORNER  CURSES_ACS_PICK('k', '+')
#define CURSES_ACS_LRCORNER  CURSES_ACS_PICK('j', '+')
#define CURSES_ACS_RTEE      CURSES_ACS_PICK('u', '+')
#define CURSES_ACS_LTEE      CURSES_ACS_PICK('t', '+')
#define CURSES_ACS_BTEE      CURSES_ACS_PICK('v', '+')
#define CURSES_ACS_TTEE      CURSES_ACS_PICK('w', '+')
#define CURSES_ACS_HLINE     CURSES_ACS_PICK('q', '-')
#define CURSES_ACS_VLINE     CURSES_ACS_PICK('x', '|')
#define CURSES_ACS_PLUS      CURSES_ACS_PICK('n', '+')

#define CURSES_ACS_S1        CURSES_ACS_PICK('o', '-')
#define CURSES_ACS_S9        CURSES_ACS_PICK('s', '_')
#define CURSES_ACS_DIAMOND   CURSES_ACS_PICK('`', '+')
#define CURSES_ACS_CKBOARD   CURSES_ACS_PICK('a', ':')
#define CURSES_ACS_DEGREE    CURSES_ACS_PICK('f', '\'')
#define CURSES_ACS_PLMINUS   CURSES_ACS_PICK('g', '#')
#define CURSES_ACS_BULLET    CURSES_ACS_PICK('~', 'o')

#define CURSES_ACS_LARROW    CURSES_ACS_PICK(',', '<')
#define CURSES_ACS_RARROW    CURSES_ACS_PICK('+', '>')
#define CURSES_ACS_DARROW    CURSES_ACS_PICK('.', 'v')
#define CURSES_ACS_UARROW    CURSES_ACS_PICK('-', '^')
#define CURSES_ACS_BOARD     CURSES_ACS_PICK('h', '#')
#define CURSES_ACS_LANTERN   CURSES_ACS_PICK('i', '*')
#define CURSES_ACS_BLOCK     CURSES_ACS_PICK('0', '#')

#define CURSES_ACS_S3        CURSES_ACS_PICK('p', '-')
#define CURSES_ACS_S7        CURSES_ACS_PICK('r', '-')
#define CURSES_ACS_LEQUAL    CURSES_ACS_PICK('y', '<')
#define CURSES_ACS_GEQUAL    CURSES_ACS_PICK('z', '>')
#define CURSES_ACS_PI        CURSES_ACS_PICK('{', 'n')
#define CURSES_ACS_NEQUAL    CURSES_ACS_PICK('|', '+')
#define CURSES_ACS_STERLING  CURSES_ACS_PICK('}', 'L')

#define CURSES_ACS_BSSB      CURSES_ACS_ULCORNER
#define CURSES_ACS_SSBB      CURSES_ACS_LLCORNER
#define CURSES_ACS_BBSS      CURSES_ACS_URCORNER
#define CURSES_ACS_SBBS      CURSES_ACS_LRCORNER
#define CURSES_ACS_SBSS      CURSES_ACS_RTEE
#define CURSES_ACS_SSSB      CURSES_ACS_LTEE
#define CURSES_ACS_SSBS      CURSES_ACS_BTEE
#define CURSES_ACS_BSSS      CURSES_ACS_TTEE
#define CURSES_ACS_BSBS      CURSES_ACS_HLINE
#define CURSES_ACS_SBSB      CURSES_ACS_VLINE
#define CURSES_ACS_SSSS      CURSES_ACS_PLUS

#ifdef CURSES_PDC_WIDE
# define CURSES_WACS_ULCORNER (&(acs_map['l']))
# define CURSES_WACS_LLCORNER (&(acs_map['m']))
# define CURSES_WACS_URCORNER (&(acs_map['k']))
# define CURSES_WACS_LRCORNER (&(acs_map['j']))
# define CURSES_WACS_RTEE     (&(acs_map['u']))
# define CURSES_WACS_LTEE     (&(acs_map['t']))
# define CURSES_WACS_BTEE     (&(acs_map['v']))
# define CURSES_WACS_TTEE     (&(acs_map['w']))
# define CURSES_WACS_HLINE    (&(acs_map['q']))
# define CURSES_WACS_VLINE    (&(acs_map['x']))
# define CURSES_WACS_PLUS     (&(acs_map['n']))

# define CURSES_WACS_S1       (&(acs_map['o']))
# define CURSES_WACS_S9       (&(acs_map['s']))
# define CURSES_WACS_DIAMOND  (&(acs_map['`']))
# define CURSES_WACS_CKBOARD  (&(acs_map['a']))
# define CURSES_WACS_DEGREE   (&(acs_map['f']))
# define CURSES_WACS_PLMINUS  (&(acs_map['g']))
# define CURSES_WACS_BULLET   (&(acs_map['~']))

# define CURSES_WACS_LARROW   (&(acs_map[',']))
# define CURSES_WACS_RARROW   (&(acs_map['+']))
# define CURSES_WACS_DARROW   (&(acs_map['.']))
# define CURSES_WACS_UARROW   (&(acs_map['-']))
# define CURSES_WACS_BOARD    (&(acs_map['h']))
# define CURSES_WACS_LANTERN  (&(acs_map['i']))
# define CURSES_WACS_BLOCK    (&(acs_map['0']))

# define CURSES_WACS_S3       (&(acs_map['p']))
# define CURSES_WACS_S7       (&(acs_map['r']))
# define CURSES_WACS_LEQUAL   (&(acs_map['y']))
# define CURSES_WACS_GEQUAL   (&(acs_map['z']))
# define CURSES_WACS_PI       (&(acs_map['{']))
# define CURSES_WACS_NEQUAL   (&(acs_map['|']))
# define CURSES_WACS_STERLING (&(acs_map['}']))

# define CURSES_WACS_BSSB     CURSES_WACS_ULCORNER
# define CURSES_WACS_SSBB     CURSES_WACS_LLCORNER
# define CURSES_WACS_BBSS     CURSES_WACS_URCORNER
# define CURSES_WACS_SBBS     CURSES_WACS_LRCORNER
# define CURSES_WACS_SBSS     CURSES_WACS_RTEE
# define CURSES_WACS_SSSB     CURSES_WACS_LTEE
# define CURSES_WACS_SSBS     CURSES_WACS_BTEE
# define CURSES_WACS_BSSS     CURSES_WACS_TTEE
# define CURSES_WACS_BSBS     CURSES_WACS_HLINE
# define CURSES_WACS_SBSB     CURSES_WACS_VLINE
# define CURSES_WACS_SSSS     CURSES_WACS_PLUS
#endif

#define CURSES_COLOR_BLACK   0

#ifdef CURSES_PDC_RGB        /* RGB */
# define CURSES_COLOR_RED    1
# define CURSES_COLOR_GREEN  2
# define CURSES_COLOR_BLUE   4
#else                 /* BGR */
# define CURSES_COLOR_BLUE   1
# define CURSES_COLOR_GREEN  2
# define CURSES_COLOR_RED    4
#endif

#define CURSES_COLOR_CYAN    (CURSES_COLOR_BLUE | CURSES_COLOR_GREEN)
#define CURSES_COLOR_MAGENTA (CURSES_COLOR_RED | CURSES_COLOR_BLUE)
#define CURSES_COLOR_YELLOW  (CURSES_COLOR_RED | CURSES_COLOR_GREEN)

#define CURSES_COLOR_WHITE   7

#define CURSES_KEY_CODE_YES  0x100  /* If get_wch() gives a key code */

#define CURSES_KEY_BREAK     0x101  /* Not on PC KBD */
#define CURSES_KEY_DOWN      0x102  /* Down arrow key */
#define CURSES_KEY_UP        0x103  /* Up arrow key */
#define CURSES_KEY_LEFT      0x104  /* Left arrow key */
#define CURSES_KEY_RIGHT     0x105  /* Right arrow key */
#define CURSES_KEY_HOME      0x106  /* home key */
#define CURSES_KEY_BACKSPACE 0x107  /* not on pc */
#define CURSES_KEY_F0        0x108  /* function keys; 64 reserved */

#define CURSES_KEY_DL        0x148  /* delete line */
#define CURSES_KEY_IL        0x149  /* insert line */
#define CURSES_KEY_DC        0x14a  /* delete character */
#define CURSES_KEY_IC        0x14b  /* insert char or enter ins mode */
#define CURSES_KEY_EIC       0x14c  /* exit insert char mode */
#define CURSES_KEY_CLEAR     0x14d  /* clear screen */
#define CURSES_KEY_EOS       0x14e  /* clear to end of screen */
#define CURSES_KEY_EOL       0x14f  /* clear to end of line */
#define CURSES_KEY_SF        0x150  /* scroll 1 line forward */
#define CURSES_KEY_SR        0x151  /* scroll 1 line back (reverse) */
#define CURSES_KEY_NPAGE     0x152  /* next page */
#define CURSES_KEY_PPAGE     0x153  /* previous page */
#define CURSES_KEY_STAB      0x154  /* set tab */
#define CURSES_KEY_CTAB      0x155  /* clear tab */
#define CURSES_KEY_CATAB     0x156  /* clear all tabs */
#define CURSES_KEY_ENTER     0x157  /* enter or send (unreliable) */
#define CURSES_KEY_SRESET    0x158  /* soft/reset (partial/unreliable) */
#define CURSES_KEY_RESET     0x159  /* reset/hard reset (unreliable) */
#define CURSES_KEY_PRINT     0x15a  /* print/copy */
#define CURSES_KEY_LL        0x15b  /* home down/bottom (lower left) */
#define CURSES_KEY_ABORT     0x15c  /* abort/terminate key (any) */
#define CURSES_KEY_SHELP     0x15d  /* short help */
#define CURSES_KEY_LHELP     0x15e  /* long help */
#define CURSES_KEY_BTAB      0x15f  /* Back tab key */
#define CURSES_KEY_BEG       0x160  /* beg(inning) key */
#define CURSES_KEY_CANCEL    0x161  /* cancel key */
#define CURSES_KEY_CLOSE     0x162  /* close key */
#define CURSES_KEY_COMMAND   0x163  /* cmd (command) key */
#define CURSES_KEY_COPY      0x164  /* copy key */
#define CURSES_KEY_CREATE    0x165  /* create key */
#define CURSES_KEY_END       0x166  /* end key */
#define CURSES_KEY_EXIT      0x167  /* exit key */
#define CURSES_KEY_FIND      0x168  /* find key */
#define CURSES_KEY_HELP      0x169  /* help key */
#define CURSES_KEY_MARK      0x16a  /* mark key */
#define CURSES_KEY_MESSAGE   0x16b  /* message key */
#define CURSES_KEY_MOVE      0x16c  /* move key */
#define CURSES_KEY_NEXT      0x16d  /* next object key */
#define CURSES_KEY_OPEN      0x16e  /* open key */
#define CURSES_KEY_OPTIONS   0x16f  /* options key */
#define CURSES_KEY_PREVIOUS  0x170  /* previous object key */
#define CURSES_KEY_REDO      0x171  /* redo key */
#define CURSES_KEY_REFERENCE 0x172  /* ref(erence) key */
#define CURSES_KEY_REFRESH   0x173  /* refresh key */
#define CURSES_KEY_REPLACE   0x174  /* replace key */
#define CURSES_KEY_RESTART   0x175  /* restart key */
#define CURSES_KEY_RESUME    0x176  /* resume key */
#define CURSES_KEY_SAVE      0x177  /* save key */
#define CURSES_KEY_SBEG      0x178  /* shifted beginning key */
#define CURSES_KEY_SCANCEL   0x179  /* shifted cancel key */
#define CURSES_KEY_SCOMMAND  0x17a  /* shifted command key */
#define CURSES_KEY_SCOPY     0x17b  /* shifted copy key */
#define CURSES_KEY_SCREATE   0x17c  /* shifted create key */
#define CURSES_KEY_SDC       0x17d  /* shifted delete char key */
#define CURSES_KEY_SDL       0x17e  /* shifted delete line key */
#define CURSES_KEY_SELECT    0x17f  /* select key */
#define CURSES_KEY_SEND      0x180  /* shifted end key */
#define CURSES_KEY_SEOL      0x181  /* shifted clear line key */
#define CURSES_KEY_SEXIT     0x182  /* shifted exit key */
#define CURSES_KEY_SFIND     0x183  /* shifted find key */
#define CURSES_KEY_SHOME     0x184  /* shifted home key */
#define CURSES_KEY_SIC       0x185  /* shifted input key */

#define CURSES_KEY_SLEFT     0x187  /* shifted left arrow key */
#define CURSES_KEY_SMESSAGE  0x188  /* shifted message key */
#define CURSES_KEY_SMOVE     0x189  /* shifted move key */
#define CURSES_KEY_SNEXT     0x18a  /* shifted next key */
#define CURSES_KEY_SOPTIONS  0x18b  /* shifted options key */
#define CURSES_KEY_SPREVIOUS 0x18c  /* shifted prev key */
#define CURSES_KEY_SPRINT    0x18d  /* shifted print key */
#define CURSES_KEY_SREDO     0x18e  /* shifted redo key */
#define CURSES_KEY_SREPLACE  0x18f  /* shifted replace key */
#define CURSES_KEY_SRIGHT    0x190  /* shifted right arrow */
#define CURSES_KEY_SRSUME    0x191  /* shifted resume key */
#define CURSES_KEY_SSAVE     0x192  /* shifted save key */
#define CURSES_KEY_SSUSPEND  0x193  /* shifted suspend key */
#define CURSES_KEY_SUNDO     0x194  /* shifted undo key */
#define CURSES_KEY_SUSPEND   0x195  /* suspend key */
#define CURSES_KEY_UNDO      0x196  /* undo key */

#define CURSES_ALT_0         0x197
#define CURSES_ALT_1         0x198
#define CURSES_ALT_2         0x199
#define CURSES_ALT_3         0x19a
#define CURSES_ALT_4         0x19b
#define CURSES_ALT_5         0x19c
#define CURSES_ALT_6         0x19d
#define CURSES_ALT_7         0x19e
#define CURSES_ALT_8         0x19f
#define CURSES_ALT_9         0x1a0
#define CURSES_ALT_A         0x1a1
#define CURSES_ALT_B         0x1a2
#define CURSES_ALT_C         0x1a3
#define CURSES_ALT_D         0x1a4
#define CURSES_ALT_E         0x1a5
#define CURSES_ALT_F         0x1a6
#define CURSES_ALT_G         0x1a7
#define CURSES_ALT_H         0x1a8
#define CURSES_ALT_I         0x1a9
#define CURSES_ALT_J         0x1aa
#define CURSES_ALT_K         0x1ab
#define CURSES_ALT_L         0x1ac
#define CURSES_ALT_M         0x1ad
#define CURSES_ALT_N         0x1ae
#define CURSES_ALT_O         0x1af
#define CURSES_ALT_P         0x1b0
#define CURSES_ALT_Q         0x1b1
#define CURSES_ALT_R         0x1b2
#define CURSES_ALT_S         0x1b3
#define CURSES_ALT_T         0x1b4
#define CURSES_ALT_U         0x1b5
#define CURSES_ALT_V         0x1b6
#define CURSES_ALT_W         0x1b7
#define CURSES_ALT_X         0x1b8
#define CURSES_ALT_Y         0x1b9
#define CURSES_ALT_Z         0x1ba

#define CURSES_CTL_LEFT      0x1bb  /* Control-Left-Arrow */
#define CURSES_CTL_RIGHT     0x1bc
#define CURSES_CTL_PGUP      0x1bd
#define CURSES_CTL_PGDN      0x1be
#define CURSES_CTL_HOME      0x1bf
#define CURSES_CTL_END       0x1c0

#define CURSES_KEY_A1        0x1c1  /* upper left on Virtual keypad */
#define CURSES_KEY_A2        0x1c2  /* upper middle on Virt. keypad */
#define CURSES_KEY_A3        0x1c3  /* upper right on Vir. keypad */
#define CURSES_KEY_B1        0x1c4  /* middle left on Virt. keypad */
#define CURSES_KEY_B2        0x1c5  /* center on Virt. keypad */
#define CURSES_KEY_B3        0x1c6  /* middle right on Vir. keypad */
#define CURSES_KEY_C1        0x1c7  /* lower left on Virt. keypad */
#define CURSES_KEY_C2        0x1c8  /* lower middle on Virt. keypad */
#define CURSES_KEY_C3        0x1c9  /* lower right on Vir. keypad */

#define CURSES_PADSLASH      0x1ca  /* slash on keypad */
#define CURSES_PADENTER      0x1cb  /* enter on keypad */
#define CURSES_CTL_PADENTER  0x1cc  /* ctl-enter on keypad */
#define CURSES_ALT_PADENTER  0x1cd  /* alt-enter on keypad */
#define CURSES_PADSTOP       0x1ce  /* stop on keypad */
#define CURSES_PADSTAR       0x1cf  /* star on keypad */
#define CURSES_PADMINUS      0x1d0  /* minus on keypad */
#define CURSES_PADPLUS       0x1d1  /* plus on keypad */
#define CURSES_CTL_PADSTOP   0x1d2  /* ctl-stop on keypad */
#define CURSES_CTL_PADCENTER 0x1d3  /* ctl-enter on keypad */
#define CURSES_CTL_PADPLUS   0x1d4  /* ctl-plus on keypad */
#define CURSES_CTL_PADMINUS  0x1d5  /* ctl-minus on keypad */
#define CURSES_CTL_PADSLASH  0x1d6  /* ctl-slash on keypad */
#define CURSES_CTL_PADSTAR   0x1d7  /* ctl-star on keypad */
#define CURSES_ALT_PADPLUS   0x1d8  /* alt-plus on keypad */
#define CURSES_ALT_PADMINUS  0x1d9  /* alt-minus on keypad */
#define CURSES_ALT_PADSLASH  0x1da  /* alt-slash on keypad */
#define CURSES_ALT_PADSTAR   0x1db  /* alt-star on keypad */
#define CURSES_ALT_PADSTOP   0x1dc  /* alt-stop on keypad */
#define CURSES_CTL_INS       0x1dd  /* ctl-insert */
#define CURSES_ALT_DEL       0x1de  /* alt-delete */
#define CURSES_ALT_INS       0x1df  /* alt-insert */
#define CURSES_CTL_UP        0x1e0  /* ctl-up arrow */
#define CURSES_CTL_DOWN      0x1e1  /* ctl-down arrow */
#define CURSES_CTL_TAB       0x1e2  /* ctl-tab */
#define CURSES_ALT_TAB       0x1e3
#define CURSES_ALT_MINUS     0x1e4
#define CURSES_ALT_EQUAL     0x1e5
#define CURSES_ALT_HOME      0x1e6
#define CURSES_ALT_PGUP      0x1e7
#define CURSES_ALT_PGDN      0x1e8
#define CURSES_ALT_END       0x1e9
#define CURSES_ALT_UP        0x1ea  /* alt-up arrow */
#define CURSES_ALT_DOWN      0x1eb  /* alt-down arrow */
#define CURSES_ALT_RIGHT     0x1ec  /* alt-right arrow */
#define CURSES_ALT_LEFT      0x1ed  /* alt-left arrow */
#define CURSES_ALT_ENTER     0x1ee  /* alt-enter */
#define CURSES_ALT_ESC       0x1ef  /* alt-escape */
#define CURSES_ALT_BQUOTE    0x1f0  /* alt-back quote */
#define CURSES_ALT_LBRACKET  0x1f1  /* alt-left bracket */
#define CURSES_ALT_RBRACKET  0x1f2  /* alt-right bracket */
#define CURSES_ALT_SEMICOLON 0x1f3  /* alt-semi-colon */
#define CURSES_ALT_FQUOTE    0x1f4  /* alt-forward quote */
#define CURSES_ALT_COMMA     0x1f5  /* alt-comma */
#define CURSES_ALT_STOP      0x1f6  /* alt-stop */
#define CURSES_ALT_FSLASH    0x1f7  /* alt-forward slash */
#define CURSES_ALT_BKSP      0x1f8  /* alt-backspace */
#define CURSES_CTL_BKSP      0x1f9  /* ctl-backspace */
#define CURSES_PAD0          0x1fa  /* keypad 0 */

#define CURSES_CTL_PAD0      0x1fb  /* ctl-keypad 0 */
#define CURSES_CTL_PAD1      0x1fc
#define CURSES_CTL_PAD2      0x1fd
#define CURSES_CTL_PAD3      0x1fe
#define CURSES_CTL_PAD4      0x1ff
#define CURSES_CTL_PAD5      0x200
#define CURSES_CTL_PAD6      0x201
#define CURSES_CTL_PAD7      0x202
#define CURSES_CTL_PAD8      0x203
#define CURSES_CTL_PAD9      0x204

#define CURSES_ALT_PAD0      0x205  /* alt-keypad 0 */
#define CURSES_ALT_PAD1      0x206
#define CURSES_ALT_PAD2      0x207
#define CURSES_ALT_PAD3      0x208
#define CURSES_ALT_PAD4      0x209
#define CURSES_ALT_PAD5      0x20a
#define CURSES_ALT_PAD6      0x20b
#define CURSES_ALT_PAD7      0x20c
#define CURSES_ALT_PAD8      0x20d
#define CURSES_ALT_PAD9      0x20e

#define CURSES_CTL_DEL       0x20f  /* clt-delete */
#define CURSES_ALT_BSLASH    0x210  /* alt-back slash */
#define CURSES_CTL_ENTER     0x211  /* ctl-enter */

#define CURSES_SHF_PADENTER  0x212  /* shift-enter on keypad */
#define CURSES_SHF_PADSLASH  0x213  /* shift-slash on keypad */
#define CURSES_SHF_PADSTAR   0x214  /* shift-star  on keypad */
#define CURSES_SHF_PADPLUS   0x215  /* shift-plus  on keypad */
#define CURSES_SHF_PADMINUS  0x216  /* shift-minus on keypad */
#define CURSES_SHF_UP        0x217  /* shift-up on keypad */
#define CURSES_SHF_DOWN      0x218  /* shift-down on keypad */
#define CURSES_SHF_IC        0x219  /* shift-insert on keypad */
#define CURSES_SHF_DC        0x21a  /* shift-delete on keypad */

#define CURSES_KEY_MOUSE     0x21b  /* "mouse" key */
#define CURSES_KEY_SHIFT_L   0x21c  /* Left-shift */
#define CURSES_KEY_SHIFT_R   0x21d  /* Right-shift */
#define CURSES_KEY_CONTROL_L 0x21e  /* Left-control */
#define CURSES_KEY_CONTROL_R 0x21f  /* Right-control */
#define CURSES_KEY_ALT_L     0x220  /* Left-alt */
#define CURSES_KEY_ALT_R     0x221  /* Right-alt */
#define CURSES_KEY_RESIZE    0x222  /* Window resize */
#define CURSES_KEY_SUP       0x223  /* Shifted up arrow */
#define CURSES_KEY_SDOWN     0x224  /* Shifted down arrow */

#define CURSES_KEY_MIN       CURSES_KEY_BREAK      /* Minimum curses key value */
#define CURSES_KEY_MAX       CURSES_KEY_SDOWN      /* Maximum curses key */

#define CURSES_KEY_F(n)      (CURSES_KEY_F0 + (n)) 

#define getch()            wgetch(stdscr)
#define ungetch(ch)        PDC_ungetch(ch)

#define CURSES_COLOR_PAIR(n)      (((chtype)(n) << CURSES_PDC_COLOR_SHIFT) & CURSES_A_COLOR)
#define CURSES_PAIR_NUMBER(n)     (((n) & CURSES_A_COLOR) >> CURSES_PDC_COLOR_SHIFT)

#define getbegyx(w, y, x)  (y = getbegy(w), x = getbegx(w))
#define getmaxyx(w, y, x)  (y = getmaxy(w), x = getmaxx(w))
#define getparyx(w, y, x)  (y = getpary(w), x = getparx(w))
#define getyx(w, y, x)     (y = getcury(w), x = getcurx(w))

#define getsyx(y, x)       { if (curscr->_leaveit) (y)=(x)=-1; \
                             else getyx(curscr,(y),(x)); }

#ifdef CURSES_NCURSES_MOUSE_VERSION
# define getmouse(x) nc_getmouse(x)
#endif

#define CURSES_PDC_CLIP_SUCCESS         0
#define CURSES_PDC_CLIP_ACCESS_ERROR    1
#define CURSES_PDC_CLIP_EMPTY           2
#define CURSES_PDC_CLIP_MEMORY_ERROR    3

#define CURSES_PDC_KEY_MODIFIER_SHIFT   1
#define CURSES_PDC_KEY_MODIFIER_CONTROL 2
#define CURSES_PDC_KEY_MODIFIER_ALT     4
#define CURSES_PDC_KEY_MODIFIER_NUMLOCK 8