project "nv-core"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/core/**.hh", "nv/interface/**.hh", "nv/detail/**.inc", "src/core/**.cc" }
	targetname "nv-core"

project "nv-lib"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/lib/**.hh", "nv/lib/**.inl", "nv/lib/**.inc", "src/lib/**.cc" }
	links { "nv-core" }
	targetname "nv-lib"

project "nv-curses"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/curses/**.hh",  "src/curses/**.cc" }
	links { "nv-core", "nv-lib" }
	targetname "nv-curses"

project "nv-fmod"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/fmod/**.hh",    "src/fmod/**.cc" }
	links { "nv-core", "nv-lib" }
	targetname "nv-fmod"

project "nv-sdl"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/sdl/**.hh",     "src/sdl/**.cc" }
	links { "nv-core", "nv-lib" }
	targetname "nv-sdl"

project "nv-gl"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/gl/**.hh",     "src/gl/**.cc" }
	links { "nv-core", "nv-lib" }
	targetname "nv-gl"

project "nv-lua"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/lua/**.hh",     "src/lua/**.cc" }
	links { "nv-core", "nv-lib" }
	targetname "nv-lua"

project "nv-rogue"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/rogue/**.hh",     "src/rogue/**.cc" }
	links { "nv-core" }
	targetname "nv-rogue"

project "nv-io"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/io/**.hh",     "src/io/**.cc" }
	links { "nv-core" }
	targetname "nv-io"

project "nv-gfx"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/gfx/**.hh",  "src/gfx/**.cc" }
	links { "nv-core" }
	targetname "nv-gfx"

project "nv-engine"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/engine/**.hh",  "src/engine/**.cc" }
	links { "nv-core", "nv-lua" }
	targetname "nv-engine"

project "nv-formats"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/formats/**.hh", "src/formats/**.cc" }
	links { "nv-core", "nv-lib", "nv-io", "nv-gfx" }
	targetname "nv-formats"

project "nv-gui"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/gui/**.hh",     "src/gui/**.cc" }
	links { "nv-core", "nv-io", "nv-gfx", "nv-lua" }
	targetname "nv-gui"

project "nv"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	links { "nv-core", "nv-lib", "nv-curses", "nv-sdl", "nv-fmod", "nv-lua", "nv-gl", "nv-rogue", "nv-io", "nv-gfx", "nv-engine", "nv-formats", "nv-gui" }
	targetname "nv"

-- injection!
solution( solution().name )
	configuration "*"
		includedirs { os.getenv("GLM_PATH") }
	configuration "gmake"
		if _ACTION == "gmake-clang" then
			buildoptions { 
				"-std=c++11",
--                                -- on Mac OS X don't try to use old stdc++
--                                "-stdlib=libc++",
				"-Weverything",
				-- obviously we don't care about C++98 compatibility
				"-Wno-c++98-compat", 
				-- obviously we don't care about C++98 compatibility
				"-Wno-c++98-compat-pedantic",
				-- an evil one has to embrace
				"-Wno-float-equal",
				-- padding is a non-issue at the moment
				"-Wno-padded",
				-- we don't want to list all 128 keys of the key
				-- enum each time, right?
				"-Wno-switch-enum",
				-- yes, we need exit time destructors for libraries
				"-Wno-exit-time-destructors",
				-- same here
				"-Wno-global-constructors",
				-- no reasonable way to fix this with abstract 
				-- interfaces.
				"-Wno-weak-vtables"
			}
			--buildoptions { 
            --                    "-stdlib=libc++"
			--}
		else
			buildoptions { "-std=c++0x" }
		end

	configuration "linux"
		linkoptions { "-ldl" }

	configuration "vs*"
		defines { "_SECURE_SCL=0", "_CRT_SECURE_NO_WARNINGS=1" }

if _ACTION == "gmake-clang" then
	premake.gcc.cc  = "clang"
	premake.gcc.cxx = "clang++"
	_ACTION = "gmake"
end

premake.action.add { 
	trigger = "gmake-clang", 
	description = "gmake file with clang overrides, needs 'make -R' to work",
}

if _ACTION == "clean" then
	for action in premake.action.each() do
		os.rmdir(action.trigger)
	end
end
