// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

// WARNING: this file is explicitly designed to fuck with your brain

#ifndef NV_VERTEX_HH
#define NV_VERTEX_HH

#include <nv/core/common.hh>
#include <nv/core/transform.hh>
#include <nv/core/math.hh>

namespace nv
{

	enum class slot : uint8
	{
		POSITION       = 0,
		TEXCOORD       = 1,
		NORMAL         = 2,
		TANGENT        = 3,
		BONEINDEX      = 4,
		BONEWEIGHT     = 5,
		COLOR          = 6,

		INDEX          = 7,
		SLOT_MAX       = 7,
		SLOT_MAX_STORE = 8,
	};

	enum buffer_hint
	{
		STATIC_DRAW,
		STREAM_DRAW,
		DYNAMIC_DRAW
	};

	enum buffer_type
	{
		VERTEX_BUFFER,
		INDEX_BUFFER,
	};


	namespace detail
	{

		template < typename VT, slot SLOT >
		struct vertex_has_slot_impl
		{
			static bool const value = false;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, slot::POSITION >
		{
		private:
			struct fallback { int position; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::position>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, slot::NORMAL >
		{
		private:
			struct fallback { int normal; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::normal>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, slot::TEXCOORD >
		{
		private:
			struct fallback { int texcoord; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::texcoord>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, slot::TANGENT >
		{
		private:
			struct fallback { int tangent; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::tangent>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, slot::BONEINDEX >
		{
		private:
			struct fallback { int boneindex; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::boneindex>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, slot::BONEWEIGHT >
		{
		private:
			struct fallback { int boneweight; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::boneweight>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, slot::COLOR >
		{
		private:
			struct fallback { int color; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::color>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT, slot SLOT, bool HAS_SLOT >
		struct vertex_slot_info_impl
		{
		};

		template < typename VT, slot SLOT >
		struct vertex_slot_info_impl < VT, SLOT, false >
		{
			typedef empty_type value_type;
			static const datatype etype  = datatype::NONE;
			static const int      offset = 0;
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, slot::POSITION, true >
		{
			typedef decltype( VT::position ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::position ) >::type;
			static const int      offset = offsetof( VT, position );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, slot::TEXCOORD, true >
		{
			typedef decltype( VT::texcoord ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::texcoord ) >::type;
			static const int      offset = offsetof( VT, texcoord );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, slot::NORMAL, true >
		{
			typedef decltype( VT::normal ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::normal ) >::type;
			static const int      offset = offsetof( VT, normal );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, slot::TANGENT, true >
		{
			typedef decltype( VT::tangent ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::tangent ) >::type;
			static const int      offset = offsetof( VT, tangent );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, slot::BONEINDEX, true >
		{
			typedef decltype( VT::boneindex ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::boneindex ) >::type;
			static const int      offset = offsetof( VT, boneindex );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, slot::BONEWEIGHT, true >
		{
			typedef decltype( VT::boneweight ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::boneweight ) >::type;
			static const int      offset = offsetof( VT, boneweight );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, slot::COLOR, true >
		{
			typedef decltype( VT::color ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::color ) >::type;
			static const int      offset = offsetof( VT, color );
		};

	}


	template < typename VT, slot SLOT >
	struct vertex_has_slot : public detail::vertex_has_slot_impl< VT, SLOT >
	{
	};


	template < typename VT, slot SLOT >
	struct vertex_slot_info : public detail::vertex_slot_info_impl< VT, SLOT, detail::vertex_has_slot_impl< VT, SLOT >::value >
	{
	};

	struct vertex_descriptor_slot
	{
		datatype etype;
		uint32   offset;
		slot     vslot;
	};

	struct vertex_descriptor
	{
		vertex_descriptor_slot slots[ slot::SLOT_MAX_STORE ];
		uint32                 count;
		uint32                 size;

		template < typename IDX >
		void initialize_index()
		{
			count = 1;
			size  = sizeof( IDX );
			slots[0].etype  = type_to_enum< IDX >::type;
			slots[0].vslot  = slot::INDEX;
			slots[0].offset = 0;
		}

		void initialize_index( datatype itype )
		{
			count = 1;
			size  = get_datatype_info( itype ).size;
			slots[0].etype  = itype;
			slots[0].vslot  = slot::INDEX;
			slots[0].offset = 0;
		}

		template < typename VTX >
		void initialize()
		{
			count = 0;
			initialize_slot< VTX, slot::POSITION >();
			initialize_slot< VTX, slot::TEXCOORD >();
			initialize_slot< VTX, slot::NORMAL >();
			initialize_slot< VTX, slot::TANGENT >();
			initialize_slot< VTX, slot::BONEINDEX >();
			initialize_slot< VTX, slot::BONEWEIGHT >();
			initialize_slot< VTX, slot::COLOR >();
			size = sizeof( VTX );
		}

		bool operator!=( const vertex_descriptor& rhs ) const
		{
			return !( *this == rhs );
		}

		bool operator==( const vertex_descriptor& rhs ) const
		{
			if ( size  != rhs.size )  return false;
			if ( count != rhs.count ) return false;
			for ( uint32 i = 0; i < count; ++i )
			{
				if ( slots[i].etype  != rhs.slots[i].etype )  return false;
				if ( slots[i].offset != rhs.slots[i].offset ) return false;
				if ( slots[i].vslot  != rhs.slots[i].vslot )  return false;
			}
			return true;
		}

	private:
		template < typename VTX, slot SLOT >
		void initialize_slot()
		{
			typedef vertex_slot_info< VTX, SLOT > slot_info;
			slots[ count ].etype  = slot_info::etype;
			if ( slots[ count ].etype != datatype::NONE )
			{
				slots[ count ].vslot  = SLOT;
				slots[ count ].offset = slot_info::offset;
				count++;
			}
		}

	};

}

#endif // NV_VERTEX_HH
