// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file program_manager.hh
 * @author Kornel Kisielewicz
 * @brief program manager
 */

#ifndef NV_ENGINE_PROGRAM_MANAGER_HH
#define NV_ENGINE_PROGRAM_MANAGER_HH

#include <nv/core/common.hh>
#include <nv/engine/resource_system.hh>

namespace nv
{

	class program_manager : public resource_manager< program >
	{
	public:
		program_manager( context* a_context );
		virtual const char* get_storage_name() const { return "programs"; }
		virtual const char* get_resource_name() const { return "program"; }
	protected:
		virtual resource_id load_resource( lua::table_guard& table );
		void load_source( lua::table_guard& table, string& out, const string& append );
		virtual void release( program p );
	private:
		context* m_context;
		string   m_vertex_head;
		string   m_fragment_head;
	};

}

#endif // NV_ENGINE_PROGRAM_MANAGER_HH
