// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/sdl.hh"

#if defined( NV_SDL_DYNAMIC )

#include "nv/core/library.hh"

#define NV_SDL_FUN( rtype, fname, fparams ) rtype (NV_SDL_APIENTRY *fname) fparams = nullptr;
#include <nv/lib/detail/sdl_functions.inc>
#if NV_SDL_VERSION == NV_SDL_12
#	include <nv/lib/detail/sdl_functions_12.inc>
#elif NV_SDL_VERSION == NV_SDL_20
#	include <nv/lib/detail/sdl_functions_20.inc>
#endif
#undef NV_SDL_FUN



bool nv::load_sdl_library( const char* path )
{
	static nv::library sdl_library;
	if ( sdl_library.is_open() ) return true;
	sdl_library.open( path );
#	define NV_SDL_FUN( rtype, fname, fparams ) *(void **) (&fname) = sdl_library.get(#fname);
#	include <nv/lib/detail/sdl_functions.inc>
#	if NV_SDL_VERSION == NV_SDL_12
#		include <nv/lib/detail/sdl_functions_12.inc>
#	elif NV_SDL_VERSION == NV_SDL_20
#		include <nv/lib/detail/sdl_functions_20.inc>
#	endif
#	undef NV_SDL_FUN
	return true;
}
#endif
