// Copyright (C) 2012-2014 ChaosForge Ltd
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include <cstdio>
#include "nv/io/c_file_system.hh"
#include "nv/io/c_stream.hh"

using namespace nv;

c_file_system::c_file_system()
{

}

c_file_system::~c_file_system()
{

}

bool c_file_system::exists( const char* fpath )
{
	FILE* file = ::fopen( fpath, "rb" );
	if ( !file )
	{
		return false;
	}
	::fclose( file );
	return true;
}

stream* c_file_system::open( const char* fpath, const char* fmode /*= "rb" */ )
{
	NV_ASSERT( fpath != nullptr && fmode != nullptr, "Bad parameters passed to open" );
	FILE* file = ::fopen( fpath, fmode );
	if ( !file )
	{
		return nullptr;
	}
	return new c_stream( file, fpath );
}
