// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/core/io_event.hh"

using namespace nv;

const char* nv::get_key_name( key_code key )
{
	switch ( key )
	{
#	define NV_KEY( id, val ) case id : return #id;
#		include <nv/detail/key_list.inc>
#	undef NV_KEY
	NV_RETURN_COVERED_DEFAULT( "KEY_UNKNOWN" );
	};
}

const char* nv::get_mouse_name( mouse_code button )
{
	switch ( button )
	{
#	define NV_MOUSE( id, val ) case id : return #id;
#		include <nv/detail/mouse_list.inc>
#	undef NV_MOUSE
	NV_RETURN_COVERED_DEFAULT( "MOUSE_UNKNOWN" );
	};
}

const char* nv::get_io_event_name( io_event_code event )
{
	switch ( event )
	{
#	define NV_IO_EVENT( id ) case id : return #id;
#		include <nv/detail/io_event_list.inc>
#	undef NV_IO_EVENT
	NV_RETURN_COVERED_DEFAULT( "EV_UNKNOWN" );
	};
}

/************************************************************************
void nv::register_io_types( type_database* db )
{
	type_enum key_enums[] = {
#	define NV_KEY( id, val ) type_enum( #id, id ),
#		include <nv/detail/key_list.inc>
#	undef NV_KEY
	};
	db->create_type<key_code>("key_code").enums( key_enums );

	type_enum mouse_enums[] = {
#	define NV_MOUSE( id, val ) type_enum( #id, id ),
#		include <nv/detail/mouse_list.inc>
#	undef NV_MOUSE
	};
	db->create_type<mouse_code>("mouse_code").enums( mouse_enums );

	type_enum io_event_enums[] = {
#	define NV_IO_EVENT( id ) type_enum( #id, id ),
#		include <nv/detail/io_event_list.inc>
#	undef NV_IO_EVENT
	};
	db->create_type<io_event_code>("event_code").enums( io_event_enums );

	type_field key_fields[] = {
		type_field( "ascii",   &key_event::ascii ),
		type_field( "code",    &key_event::code ),
		type_field( "shift",   &key_event::shift ),
		type_field( "control", &key_event::control ),
		type_field( "alt",     &key_event::alt ),
		type_field( "pressed", &key_event::pressed ),
	};
	db->create_type<key_event>("key_event").fields( key_fields );

	type_field mouse_button_fields[] = {
		type_field( "x",       &mouse_button_event::x ),
		type_field( "y",       &mouse_button_event::y ),
		type_field( "button",  &mouse_button_event::button ),
		type_field( "pressed", &mouse_button_event::pressed ),
		type_field( "code",    &mouse_button_event::code ),
	};
	db->create_type<mouse_button_event>("mouse_button_event").fields( mouse_button_fields );

	type_field mouse_move_fields[] = {
		type_field( "x",       &mouse_move_event::x ),
		type_field( "y",       &mouse_move_event::y ),
		type_field( "rx",      &mouse_move_event::rx ),
		type_field( "ry",      &mouse_move_event::ry ),
		type_field( "pressed", &mouse_move_event::pressed ),
		type_field( "code",    &mouse_move_event::code ),
	};
	db->create_type<mouse_move_event>("mouse_move_event").fields( mouse_move_fields );

	type_field mouse_wheel_fields[] = {
		type_field( "x",       &mouse_wheel_event::x ),
		type_field( "y",       &mouse_wheel_event::y ),
	};
	db->create_type<mouse_wheel_event>("mouse_wheel_event").fields( mouse_wheel_fields );

	type_field joy_button_fields[] = {
		type_field( "id",      &joy_button_event::id ),
		type_field( "button",  &joy_button_event::button ),
		type_field( "pressed", &joy_button_event::pressed ),
	};
	db->create_type<joy_button_event>("joy_button_event").fields( joy_button_fields );

	type_field joy_axis_fields[] = {
		type_field( "id",      &joy_axis_event::id ),
		type_field( "axis",    &joy_axis_event::axis ),
		type_field( "value",   &joy_axis_event::value ),
	};
	db->create_type<joy_axis_event>("joy_axis_event").fields( joy_axis_fields );

	type_field joy_hat_fields[] = {
		type_field( "id",      &joy_hat_event::id ),
		type_field( "hat",     &joy_hat_event::hat ),
		type_field( "value",   &joy_hat_event::value ),
	};
	db->create_type<joy_hat_event>("joy_hat_event").fields( joy_hat_fields );

	type_field joy_ball_fields[] = {
		type_field( "id",      &joy_ball_event::id ),
		type_field( "ball",    &joy_ball_event::ball ),
		type_field( "rx",      &joy_ball_event::rx ),
		type_field( "ry",      &joy_ball_event::ry ),
	};
	db->create_type<joy_ball_event>("joy_ball_event").fields( joy_ball_fields );

	type_field system_fields[] = {
		type_field( "sys_type", &system_event::sys_type ),
		type_field( "param1",   &system_event::param1 ),
		type_field( "param2",   &system_event::param2 ),
	};
	db->create_type<system_event>("system_event").fields( system_fields );
}
************************************************************************/
