// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_element.hh
 * @author Kornel Kisielewicz
 * @brief GUI Renderer
 */

#ifndef NV_GUI_RENDERER_HH
#define NV_GUI_RENDERER_HH

#include <nv/object.hh>
#include <nv/position.hh>
#include <nv/math.hh>
#include <nv/gui/gui_common.hh>
#include <nv/gui/gui_style.hh>
#include <nv/interface/window.hh>
#include <nv/interface/device.hh>
#include <nv/interface/context.hh>
#include <nv/interface/camera.hh>
#include <nv/gfx/sliced_buffer.hh>
#include <nv/gfx/texture_atlas.hh>
#include <nv/gfx/texture_font.hh>

namespace nv
{
	namespace gui
	{
		struct vertex
		{
			ivec2 position;
			vec2  texcoord;
			vec4  color;
			vertex() {}
			vertex( const nv::ivec2& cr, const nv::vec2& tc, const nv::vec4& c )
				: position( cr ), texcoord( tc ), color( c ) {}
		};

		class renderer
		{
		public:
			renderer( window* w );
			texture_font* get_font( size_t name ) const;
			vec4 get_image( size_t name ) const;
			void load_style( const std::string& filename );
			size_t load_font( const std::string& filename, size_t size );
			size_t load_image( const std::string& filename );
			void redraw( element* e, uint32 );
			void draw( element* e );
			void draw();
			virtual ~renderer();
		private:
			typedef std::unordered_map< std::string, size_t > names;
			typedef std::vector< texture_font* >              font_vector;
			typedef std::vector< vec4 >                       image_vector;

			context*      m_context;
			window*       m_window;
			style         m_style; 
			rectangle     m_area;
			names         m_image_names;
			image_vector  m_images;
			names         m_font_names;
			font_vector   m_fonts;
			texture_atlas m_atlas;
			bool          m_reupload;

			scene_state   m_scene_state;
			render_state  m_render_state;
			render_data*  m_render_data;
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_RENDERER_HH