// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gfx/debug_draw.hh"

#include "nv/interface/device.hh"

static const char *nv_debug_draw_vertex_shader =
	"#version 120\n"
	"attribute vec3 nv_position;\n"
	"attribute vec3 nv_color;\n"
	"varying vec3 v_color;\n"
	"uniform mat4 nv_m_mvp;\n"
	"void main(void)\n"
	"{\n"
	"	gl_Position = nv_m_mvp * vec4 (nv_position, 1.0);\n"
	"	v_color     = nv_color;\n"
	"}\n";
static const char *nv_debug_draw_fragment_shader =
	"#version 120\n"
	"varying vec3 v_color;\n"
	"void main(void)\n"
	"{\n"
	"	gl_FragColor = vec4( v_color, 1.0 );\n"
	"}\n";

nv::debug_data::debug_data( device* a_device )
	: m_device( a_device ), m_program(), m_va()
{
	m_program = m_device->create_program( nv_debug_draw_vertex_shader, nv_debug_draw_fragment_shader );
}

void nv::debug_data::update()
{
	m_device->release( m_va );
	m_va = m_device->create_vertex_array( m_data, nv::STATIC_DRAW );
}

void nv::debug_data::reset()
{
	m_data.clear();
}

void nv::debug_data::push_line( const vec3& a, const vec3& b, const vec3& color )
{
	m_data.emplace_back( a, color );
	m_data.emplace_back( b, color );
}

void nv::debug_data::push_aabox( const vec3& a, const vec3& b, const vec3& color )
{
	vec3 corners[8] =
	{
		vec3( a.x, a.y, a.z ), vec3( b.x, a.y, a.z ), vec3( b.x, a.y, b.z ), vec3( a.x, a.y, b.z ),
		vec3( a.x, b.y, a.z ), vec3( b.x, b.y, a.z ), vec3( b.x, b.y, b.z ), vec3( a.x, b.y, b.z ),
	};

	push_line( corners[0], corners[1], color );
	push_line( corners[1], corners[2], color );
	push_line( corners[2], corners[3], color );
	push_line( corners[3], corners[0], color );
	push_line( corners[0], corners[4], color );
	push_line( corners[1], corners[5], color );
	push_line( corners[2], corners[6], color );
	push_line( corners[3], corners[7], color );
	push_line( corners[4], corners[5], color );
	push_line( corners[5], corners[6], color );
	push_line( corners[6], corners[7], color );
	push_line( corners[7], corners[4], color );
}

nv::debug_data::~debug_data()
{
	m_device->release( m_va );
	m_device->release( m_program );
}
