// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_texture2d.hh"

#include "nv/gl/gl_enum.hh"
#include "nv/lib/gl.hh"

using namespace nv;

nv::gl_texture2d::gl_texture2d( ivec2 size, pixel_format aformat, datatype adatatype, sampler asampler, void* data /*= nullptr */ )
	: texture2d( size, aformat, adatatype, asampler )
{
	glGenTextures( 1, &glid );

	glBindTexture( GL_TEXTURE_2D, glid );

	// Detect if mipmapping was requested
	if (( asampler.filter_min != sampler::LINEAR && asampler.filter_min != sampler::NEAREST ) ||
		( asampler.filter_max != sampler::LINEAR && asampler.filter_max != sampler::NEAREST ))
	{
		glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE);
	}

	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (int)nv::sampler_filter_to_enum( m_sampler.filter_min ) );
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (int)nv::sampler_filter_to_enum( m_sampler.filter_max ) );
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, (int)nv::sampler_wrap_to_enum( m_sampler.wrap_s) );
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, (int)nv::sampler_wrap_to_enum( m_sampler.wrap_t) );

	if (data)
	{
		glTexImage2D( GL_TEXTURE_2D, 0, (GLint)nv::image_format_to_enum(m_format.format), m_size.x, m_size.y, 0, nv::image_format_to_enum(m_format.format), nv::datatype_to_gl_enum(m_format.type), data );
	}

	glBindTexture( GL_TEXTURE_2D, 0 );
}

nv::gl_texture2d::~gl_texture2d()
{
	if ( glid != 0 )
	{
		glDeleteTextures( 1, &glid );
	}
}

