// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_vertex_buffer.hh"

#include "nv/lib/gl.hh"
#include "nv/gl/gl_enum.hh"

using namespace nv;

gl_vertex_buffer::gl_vertex_buffer( buffer_hint hint, size_t size, const void* data ) 
	: vertex_buffer( hint, size ), m_name()
{
	glBindBuffer( GL_ARRAY_BUFFER, m_name.get_value() );
	glBufferData( GL_ARRAY_BUFFER, (GLsizeiptr)m_size, data, buffer_hint_to_enum( m_hint ) );
	glBindBuffer( GL_ARRAY_BUFFER, 0 );
}

gl_index_buffer::gl_index_buffer( buffer_hint hint, size_t size, const void* data ) 
	: index_buffer( hint, size ), m_name()
{
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, m_name.get_value() );
	glBufferData( GL_ELEMENT_ARRAY_BUFFER, (GLsizeiptr)m_size, data, buffer_hint_to_enum( m_hint ) );
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, 0 );
}

