// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_MESH_CREATOR_HH
#define NV_MESH_CREATOR_HH

#include <nv/common.hh>
#include <nv/math.hh>
#include <nv/interface/mesh_data.hh>

namespace nv
{

	class mesh_data_creator
	{
	public:
		mesh_data_creator( mesh_data* data ) : m_data( data ) {}
		// assumes that position and normal is vec3, tangent is vec4
		void transform( float scale, const mat3& r33 );
	private:
		mesh_data* m_data;
	};

	class mesh_nodes_creator
	{
	public:
		mesh_nodes_creator( mesh_nodes_data* data ) : m_data( data ) {}
		// assumes that keys are equally spaced
		void pre_transform_keys();
		// assumes that keys are equally spaced
		void merge_keys();
		void transform( float scale, const mat3& r33 );
	private:
		mesh_nodes_data* m_data;
	};

	class mesh_creator
	{
	public:
		mesh_creator( mesh_data_pack* pack ) : m_pack( pack ) {}
		// assumes that keys are equally spaced
		void pre_transform_keys() { mesh_nodes_creator( m_pack->m_nodes ).pre_transform_keys(); }
		// assumes that keys are equally spaced
		void merge_keys() { mesh_nodes_creator( m_pack->m_nodes ).merge_keys(); }
		// assumes that position and normal is vec3, tangent is vec4
		void transform( float scale, const mat3& r33 ) 
		{
			for ( size_t m = 0; m < m_pack->m_count; ++m )
				mesh_data_creator( &(m_pack->m_meshes[m]) ).transform( scale, r33 );
			mesh_nodes_creator( m_pack->m_nodes ).transform( scale, r33 );
		}
	private:
		mesh_data_pack* m_pack;
	};
}

#endif // NV_MESH_CREATOR_HH
