// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_ASSIMP_LOADER_HH
#define NV_ASSIMP_LOADER_HH

#include <nv/common.hh>
#include <nv/io/string_table.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/animated_mesh.hh>

namespace nv 
{

	class assimp_loader : public mesh_loader
	{
	public:
		assimp_loader( const string& a_ext, const mat3& a_rotate_transform, float a_scale, bool pre_transform, uint32 a_assimp_flags = 0 );
		assimp_loader( const string& a_ext, bool pre_transform, uint32 a_assimp_flags = 0 );
		virtual bool load( stream& source );
		virtual mesh_data* release_mesh_data( size_t index = 0 );
		virtual size_t get_mesh_count() const { return m_mesh_count; }
		virtual ~assimp_loader();
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_nodes_data_count() const;
		virtual mesh_nodes_data* release_mesh_nodes_data( size_t index = 0 );
		mesh_nodes_data* release_animation( size_t index );
		void scene_report() const;
	private:
		mesh_nodes_data* release_merged_bones( mesh_data* meshes );
		bool load_bones( size_t index, std::vector< mesh_node_data >& bones );
		void load_mesh_data( mesh_data* data, size_t index );
		void initialize( const string& a_ext, const mat3& a_rotate_transform, float a_scale, uint32 a_assimp_flags );
		sint16 load_node( uint32 anim_id, mesh_node_data* nodes, const void* vnode, sint16 this_id, sint16 parent_id, uint32& max_frames );
		uint32 count_nodes( const void* node ) const;
		void create_transformed_keys( mesh_node_data* data, const void* vnode, const mesh_node_data* parent );
		void create_direct_keys( mesh_node_data* data, const void* vnode );

		string_table_creator m_strings;
		string m_ext;
		mat3   m_r33;
		mat3   m_ri33;
		float  m_scale;
		uint32 m_assimp_flags;
		const void* m_scene;
		size_t m_mesh_count;
		bool   m_flat;
	};

	struct assimp_plain_vtx 
	{
		vec3 position;
		vec3 normal;
		vec2 texcoord;
		vec4 tangent;

		assimp_plain_vtx() {}
		assimp_plain_vtx( const vec3& v, const vec2& t, const vec3& n, const vec4& g )
		{
			position = v;
			texcoord = t;
			normal   = n;
			tangent  = g;
		}
	};

	struct assimp_skinned_vtx 
	{
		vec3  position;
		vec3  normal;
		vec2  texcoord;
		vec4  tangent;
		ivec4 boneindex;
		vec4  boneweight;

		assimp_skinned_vtx() {}
		assimp_skinned_vtx( const vec3& v, const vec2& t, const vec3& n, const vec4& g )
		{
			position = v;
			texcoord = t;
			normal   = n;
			tangent  = g;
		}
	};

}

#endif // NV_ASSIMP_LOADER_HH
