// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_SKELETAL_MESH_HH
#define NV_SKELETAL_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/animated_mesh.hh>
#include <nv/formats/md5_loader.hh>
#include <nv/formats/nmd_loader.hh>

namespace nv
{

	class skeletal_animation_entry : public animation_entry
	{
	public:
		friend class skeletal_mesh;

		skeletal_animation_entry( const std::string& name, md5_animation* a_animation, bool a_looping ) 
			: animation_entry( name ), m_animation( a_animation ), m_looping( a_looping ) {}
		virtual uint32 get_frame_rate() const { return m_animation->get_frame_rate(); }
		virtual uint32 get_frame_count() const { return m_animation->get_frame_count(); }
		virtual bool is_looping() const { return m_looping; }
		uint32 get_num_joints() const { return m_animation->get_num_joints();}
		void update_skeleton( transform* tr, float time ) const { return m_animation->update_skeleton( tr, time );}
	protected:
		md5_animation* m_animation;
		bool           m_looping;
	};

	class skeletal_mesh : public animated_mesh
	{
	public:
		skeletal_mesh( device* a_device, const mesh_data* a_mesh_data, const mesh_nodes_data* bones );
		virtual size_t get_index_count() const { return m_indices; }
		virtual void run_animation( animation_entry* a_anim );
		virtual void update_animation( animation_entry* a_anim, uint32 a_anim_time );
		virtual ~skeletal_mesh();
	protected:
		uint32                       m_indices;
		dynamic_array< md5_vtx_pnt > m_pntdata;
		dynamic_array< transform >   m_pos_offset;
		dynamic_array< transform >   m_bone_offset;
;
		const mesh_data*             m_data;
		const md5_vtx_pntiw*         m_vtx_data;
		dynamic_array< transform >   m_transform;
	};

 	class skeletal_animation_entry_gpu : public animation_entry
 	{
 	public:
 		skeletal_animation_entry_gpu( const std::string& name, const mesh_nodes_data* anim, bool a_looping );
 		virtual uint32 get_frame_rate() const { return m_node_data->get_frame_rate(); }
 		virtual float get_duration() const { return m_node_data->get_duration(); }
 		virtual bool is_looping() const { return m_looping; }
		void prepare( const mesh_nodes_data* bones );
		void update_skeleton( mat4* tr, uint32 time ) const;
		~skeletal_animation_entry_gpu();
 	protected:
		void animate_rec( mat4* data, float time, uint32 node_id, const mat4& parent_mat ) const;
		const mesh_nodes_data* m_node_data;
		std::vector< uint32 >* m_children;
		sint16* m_bone_ids;
		mat4* m_offsets;
		bool m_prepared;
 		bool m_looping;
 	};

	class skeletal_mesh_gpu : public animated_mesh
	{
	public:
		skeletal_mesh_gpu( device* a_device, const mesh_data* a_mesh, const mesh_nodes_data* a_bone_data );
		virtual size_t get_index_count() const { return m_index_count; }
		virtual void run_animation( animation_entry* a_anim );
		virtual void update( program* a_program ) const;
		virtual void update_animation( animation_entry* a_anim, uint32 
			a_anim_time );
		virtual transform get_node_transform( uint32 node_id ) const;
		virtual mat4 get_node_matrix( uint32 node_id ) const;
		~skeletal_mesh_gpu() { delete m_transform; }
	protected:
		const mesh_nodes_data* m_bone_data;
		uint32 m_index_count;
		mat4*  m_transform;
	};

} // namespace nv

#endif // NV_SKELETAL_MESH_HH
