// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file animated_mesh.hh
 * @author Kornel Kisielewicz
 * @brief animated_mesh
 */

#ifndef NV_ANIMATED_MESH_HH
#define NV_ANIMATED_MESH_HH

#include <nv/common.hh>
#include <nv/math.hh>
#include <nv/transform.hh>
#include <nv/interface/context.hh>

namespace nv
{

	class animation_entry
	{
	public:
		animation_entry( const std::string& name ) : m_name( name ) {}
		virtual const std::string& get_name() const { return m_name; }
		virtual uint32 get_frame_rate() const = 0;
		virtual uint32 get_frame_count() const = 0;
		virtual bool is_looping() const = 0;
		virtual ~animation_entry() {}
	protected:
		std::string m_name;
	};

	class animated_mesh : public mesh_interface
	{
	public:
		animated_mesh() {}
		virtual void update_animation( animation_entry*, uint32 ) {}
		virtual void run_animation( animation_entry* ) {}
		virtual transform get_tag( const std::string& ) const { return transform(); }
	};


}

#endif // NV_ANIMATED_MESH_HH
