// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_element.hh
 * @author Kornel Kisielewicz
 * @brief GUI Element
 */

#ifndef NV_GUI_ELEMENT_HH
#define NV_GUI_ELEMENT_HH

#include <nv/common.hh>
#include <nv/position.hh>
#include <nv/io_event.hh>
#include <nv/gui/gui_common.hh>

namespace nv
{
	namespace gui
	{

		class element
		{
		public:
			/// List type
			typedef std::list<handle> list;


			element()
				: m_id( "" )
				, m_child_count(0)
				, m_class("")
				, m_enabled( true )
				, m_visible( true )
				, m_dirty( true )
				, m_render_data( nullptr ) {}

			string    m_id;              ///< id type of the object
			handle    m_this;            ///< pointer to parent
			handle    m_parent;          ///< pointer to parent
			list      m_children;        ///< children objects
			size_t    m_child_count;     ///< number of children
			string    m_class; ///< Class name.
			string    m_text; ///< Displayed label or text.
			rectangle m_relative; ///< Position relative to parent.
			rectangle m_absolute; ///< Position relative to window/screen.
			bool m_enabled; ///< Whether the element accepts events.
			bool m_visible; ///< Whether the element is drawn.
			bool m_dirty; ///< Whether the element needs updating.
			render_data* m_render_data; ///<   -?-
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ELEMENT_HH
