// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_environment.hh
 * @author Kornel Kisielewicz
 * @brief GUI Environment (root)
 */

#ifndef NV_GUI_ENVIRONMENT_HH
#define NV_GUI_ENVIRONMENT_HH

#include <nv/gui/gui_element.hh>
#include <nv/gui/gui_style.hh>
#include <nv/lua/lua_state.hh>
#include <nv/io_event.hh>
#include <nv/interface/window.hh>
#include <nv/array.hh>

namespace nv
{

	namespace gui
	{

		class environment
		{
		public:
			environment( window* w, const std::string& shader_path = "gui" );
			// temporary
			void load_style( const std::string& filename );
			element* create_element( element* parent, const rectangle& r );
			void update();
			void draw();
			void destroy_element( element* e );
			bool process_io_event( const io_event& ev );
			virtual ~environment();
		protected:
			element* get_element( const position& p );
			void add_child( element* child );
			void destroy_children( element* e );
			void update( element* e, uint32 elapsed );
			void draw( element* e );
			bool process_io_event( element* e, const io_event& ev );
			element* get_deepest_child( element* e, const position& p );
			void move_to_top( element* child );
			void move_to_bottom( element* child );
			void set_relative( element* e, const rectangle& r );
			void set_relative( element* e, const position& p );
			void recalculate_absolute( element* e );
			
			renderer*    m_renderer;
			window*      m_window;
			element*     m_screen;
			rectangle    m_area;
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ENVIRONMENT_HH
