// Copyright (C) 2012 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_ROOT_HH
#define NV_ROOT_HH

#include <nv/common.hh>
#include <nv/object.hh>
#include <nv/string.hh>
#include <list>

namespace nv
{

	/**
	 * Implements the root of a object tree-like structure.
	 */
	class root 
	{
	public:
		root() {}
		template < typename T >
		object* create_object( const std::string& id )
		{
			object* o = new T(id);
			object_created(o);
			return o;
		}
		void destroy_children( object* o );
		virtual void destroy_object( object* o );
		virtual ~root() {}
	protected:
		virtual void object_created( object* ) {}
	};
	
} // namespace nv

#endif // NV_ROOT_HH
