// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/root.hh"

#include "nv/uid.hh"
#include "nv/lua/lua_state.hh"

void nv::root::object_created( object* o )
{
	if ( m_uid_store )
	{
		o->m_uid = m_uid_store->insert( o );
	}
}

void nv::root::destroy_object( object* o )
{
	destroy_children( o );
	o->detach();
	if ( m_lua_state && o->m_lua_index != lua::ref_none )
	{
		m_lua_state->unregister_object( o->m_lua_index );
	}
	if ( m_uid_store && o->m_uid != 0 )
	{
		m_uid_store->remove( o->m_uid );
	}
	if ( o != this)	delete o;
}

void nv::root::destroy_children( object* o )
{
	while ( !o->m_children.empty() )
	{
		destroy_object( o->m_children.front() );
	}
}

void nv::root::register_with_lua( object* o, const char* lua_name, const char* storage )
{
	if ( m_lua_state )
	{
		if ( lua_name != nullptr )
		{
			o->m_lua_index       = m_lua_state->register_object( o, lua_name );
		}
		if ( storage != nullptr )
		{
			o->m_lua_proto_index = m_lua_state->register_proto( o->get_id().c_str(), storage );
		}
	}

}

