// Copyright (C) 2011 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gfx/skeletal_mesh.hh"

#include <glm/gtc/matrix_access.hpp>
#include <glm/gtx/matrix_interpolation.hpp>
#include "nv/interface/context.hh"
#include "nv/interface/device.hh"


nv::skeletal_mesh::skeletal_mesh( context* a_context, md5_mesh_data* a_mesh_data )
	: animated_mesh()
	, m_mesh_data( a_mesh_data )
	, m_animation( nullptr )
{
	m_va = a_context->get_device()->create_vertex_array( a_mesh_data, nv::STREAM_DRAW );
}


void nv::skeletal_mesh::setup_animation( md5_animation* a_anim )
{
	if ( m_animation ) m_animation->reset_animation();
	m_animation = a_anim;
	// TODO : INSTANCE!
	m_animation->reset_animation();
}

void nv::skeletal_mesh::update( uint32 ms )
{
	if (m_animation != nullptr)
	{
		m_animation->update( ms * 0.001f );
		m_mesh_data->apply( *m_animation );
		vertex_buffer* vb = m_va->find_buffer( nv::POSITION );
		const mesh_raw_channel* pch = m_mesh_data->get_channel_data()[0];
		vb->bind();
		vb->update( (const void*)pch->data, 0, pch->size );
		vb->unbind();
	}
}

nv::skeletal_mesh::~skeletal_mesh()
{
	delete m_va;
	// TODO : INSTANCE!
	//	delete m_mesh_data;
}

void nv::skeletal_mesh::run_animation( animation_entry* a_anim )
{
	skeletal_animation_entry * anim = down_cast<skeletal_animation_entry>(a_anim);
	// TODO : INSTANCE!
	setup_animation( anim->m_animation );
}
