// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file camera.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Camera interface class
 */

#ifndef NV_CAMERA_HH
#define NV_CAMERA_HH

#include <nv/common.hh>
#include <nv/math.hh>

namespace nv
{
	class camera
	{
	public:
		camera() {}

		void set_lookat( const vec3& eye, const vec3& focus, const vec3& up )
		{
			m_view  = glm::lookAt( eye, focus, up );
		}

		void set_perspective( f32 fov, f32 aspect, f32 near, f32 far )
		{
			m_projection = glm::perspective( fov, aspect, near, far );
		}
		const mat4& get_projection() const 
		{
			return m_projection;
		}
		const mat4& get_view() const 
		{
			return m_view;
		}
	private:
		mat4 m_projection;
		mat4 m_view;
	};
}

#endif // NV_CAMERA_HH
