// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_SKELETAL_MESH_HH
#define NV_SKELETAL_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/formats/md5_loader.hh>

namespace nv
{

	class skeletal_mesh
	{
	public:
		skeletal_mesh( context* a_context, program* a_program, md5_loader* a_loader );
		virtual void setup_animation( md5_animation* a_anim );
		virtual void update( uint32 ms );
		virtual void draw( render_state& rstate );
		program* get_program() { return m_program; }
		virtual ~skeletal_mesh();
	protected:
		context*      m_context;
		program*      m_program;
		vertex_array* m_va;

		vertex_buffer* m_vb_position;
		vertex_buffer* m_vb_normal;
		vertex_buffer* m_vb_tangent;

		md5_loader*    m_data;
		md5_animation* m_animation;

		uint32 m_start_frame;
		uint32 m_stop_frame;
		uint32 m_last_frame;
		uint32 m_next_frame;
		uint32 m_time;
		uint32 m_fps;
		f32    m_interpolation;
		bool   m_looping;
		bool   m_active;
	};

} // namespace nv

#endif // NV_SKELETAL_MESH_HH
