// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
#ifndef NV_LUA_GLM_HH
#define NV_LUA_GLM_HH

#include <new>
#include <nv/common.hh>
#include <nv/math.hh>
#include <nv/lua/lua_values.hh>

namespace nv
{
	namespace lua
	{
		void register_glm( lua_State* L );

		namespace detail
		{
			template< typename T > inline const char* glm_metatable_name() { static_assert(sizeof(T) == 0, "Type not implemented!"); return NULL; }
			template<> inline const char* glm_metatable_name< nv::ivec2 >() { return "ivec2"; }
			template<> inline const char* glm_metatable_name< nv::ivec3 >() { return "ivec3"; }
			template<> inline const char* glm_metatable_name< nv::ivec4 >() { return "ivec4"; }
			template<> inline const char* glm_metatable_name< nv::vec2  >() { return "vec2"; }
			template<> inline const char* glm_metatable_name< nv::vec3  >() { return "vec3"; }
			template<> inline const char* glm_metatable_name< nv::vec4  >() { return "vec4"; }

			template< typename T >
			bool is_vec( lua_State* L, int index )
			{
				return is_userdata( L, index, detail::glm_metatable_name<T>() );
			}

			template< typename T >
			T to_vec( lua_State* L, int index )
			{
				return *(T*)check_userdata( L, index, detail::glm_metatable_name<T>() );
			}

			template< typename T >
			T* to_pvec( lua_State* L, int index )
			{
				return (T*)check_userdata( L, index, detail::glm_metatable_name<T>() );
			}

			template< typename T >
			void push_vec( lua_State* L, const T& v )
			{
				push_userdata( L, v, detail::glm_metatable_name<T>() );
			}
		}

		template< typename T >
		struct pass_traits< glm::detail::tvec2<T> >
		{
			typedef glm::detail::tvec2<T> value_type;
			static void push( lua_State *L, const value_type& p ) { detail::push_vec< value_type >( L, p ); }
			static void pop( lua_State *L, value_type& p ) { p = detail::to_vec< value_type >( L, -1 ); detail::pop_and_discard( L, 1 ); }
		};

		template< typename T >
		struct pass_traits< glm::detail::tvec3<T> >
		{
			typedef glm::detail::tvec3<T> value_type;
			static void push( lua_State *L, const value_type& p ) { detail::push_vec< value_type >( L, p ); }
			static void pop( lua_State *L, value_type& p ) { p = detail::to_vec< value_type >( L, -1 ); detail::pop_and_discard( L, 1 ); }
		};

		template< typename T >
		struct pass_traits< glm::detail::tvec4<T> >
		{
			typedef glm::detail::tvec4<T> value_type;
			static void push( lua_State *L, const value_type& p ) { detail::push_vec< value_type >( L, p ); }
			static void pop( lua_State *L, value_type& p ) { p = detail::to_vec< value_type >( L, -1 ); detail::pop_and_discard( L, 1 ); }
		};
	}

}


#endif // NV_LUA_GLM_HH
