// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/random.hh"
#include "nv/time.hh"

using namespace nv;

random::random( random::seed_type seed /*= 0 */ )
	: rng( seed == 0 ? randomized_seed() : seed )
{
	
}

random::seed_type random::randomize()
{
	seed_type seed = randomized_seed();
	rng.seed( seed );
	return seed;
}

void random::set_seed( random::seed_type seed /*= 0 */ )
{
	rng.seed( seed == 0 ? randomized_seed() : seed );
}

random& random::get()
{
	static random default_rng;
	return default_rng;
}

random::result_type random::rand()
{
	return rng();
}

sint32 random::srand( sint32 val )
{
	std::uniform_int_distribution<sint32> dist( 0, val - 1 );
	return dist( rng );
}

uint32 random::urand( uint32 val )
{
	std::uniform_int_distribution<uint32> dist( 0, val - 1 );
	return dist( rng );
}

f32 random::frand( f32 val )
{
	std::uniform_real_distribution<f32> dist( 0, val );
	return dist( rng );
}

sint32 random::srange( sint32 min, sint32 max )
{
	std::uniform_int_distribution<sint32> dist( min, max );
	return dist( rng );
}

uint32 random::urange( uint32 min, uint32 max )
{
	std::uniform_int_distribution<uint32> dist( min, max );
	return dist( rng );
}

f32 random::frange( f32 min, f32 max )
{
	std::uniform_real_distribution<f32> dist( min, max );
	return dist( rng );
}

uint32 random::dice( uint32 count, uint32 sides )
{
	std::uniform_int_distribution<uint32> dist( 1, sides );
	uint32 result = 0;
	while (count-- > 0)
	{
		result += dist( rng );
	};
	return result;
}

random::seed_type random::randomized_seed()
{
	return narrow_cast< seed_type >( get_ticks() );
}
