// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file type_traits.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief type traits
 */

#ifndef NV_TYPE_TRAITS_HH
#define NV_TYPE_TRAITS_HH

#include <nv/common.hh>
#include <type_traits>

namespace nv
{
#if NV_COMPILER == NV_MSVC
	using std::underlying_type;
#elif NV_COMPILER == NV_CLANG
	template < typename T >
	struct underlying_type
	{
		typedef __underlying_type(T) type;
	};
#else
	template< typename T >
	struct underlying_type
	{
		typedef typename std::conditional<
			T( -1 ) < T( 0 ),
			typename std::make_signed< T >::type,
			typename std::make_unsigned< T >::type
			>::type type;
	};
#endif
}

#endif // NV_TYPE_TRAITS_HH
