// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_MATH_HH
#define NV_MATH_HH

#if NV_COMPILER == NV_GNUC
#pragma GCC system_header
#elif NV_COMPILER == NV_CLANG
#pragma clang system_header
#endif

#include <nv/common.hh>
#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtc/type_ptr.hpp>

namespace nv
{

	typedef glm::detail::tvec2<sint8> i8vec2;
	typedef glm::detail::tvec3<sint8> i8vec3;
	typedef glm::detail::tvec4<sint8> i8vec4;

	typedef glm::vec2 vec2;
	typedef glm::vec3 vec3;
	typedef glm::vec4 vec4;

	typedef glm::ivec2 ivec2;
	typedef glm::ivec3 ivec3;
	typedef glm::ivec4 ivec4;

	typedef glm::mat2 mat2;
	typedef glm::mat3 mat3;
	typedef glm::mat4 mat4;

	typedef glm::quat quat;

	template <typename T> 
	struct datatype_traits 
	{
		typedef T type;
		typedef T base_type;
		static const size_t size = 1;
	};

	template <typename T> 
	struct datatype_traits< glm::detail::tvec2<T> > 
	{
		typedef glm::detail::tvec2<T> type;
		typedef typename type::value_type base_type;
		static const size_t size = 2;
	};

	template <typename T> 
	struct datatype_traits< glm::detail::tvec3<T> > 
	{
		typedef glm::detail::tvec3<T> type;
		typedef typename type::value_type base_type;
		static const size_t size = 3;
	};

	template <typename T> 
	struct datatype_traits< glm::detail::tvec4<T> > 
	{
		typedef glm::detail::tvec4<T> type;
		typedef typename type::value_type base_type;
		static const size_t size = 4;
	};

	using glm::max;
	using glm::min;

} // namespace nv

#endif // NV_MATH_HH
