#version 120

attribute vec2 nv_texcoord;
attribute vec3 nv_position;
attribute vec3 nv_normal;
attribute vec3 nv_next_position;
attribute vec3 nv_next_normal;

varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
varying vec2 v_texcoord;

uniform mat4 matrix_mvp;
uniform mat4 nv_m_modelview;
uniform mat4 nv_m_projection;
uniform mat3 nv_m_normal;
uniform float nv_interpolate;
uniform vec3 light_position;

void main(void) {
	vec4 vertex     = vec4( mix( nv_position, nv_next_position, nv_interpolate ), 1.0 );
	vec3 eye_pos    = vec3( nv_m_modelview * vertex );
	v_normal        = normalize( nv_m_normal * mix( nv_normal, nv_next_normal, nv_interpolate ) );
	v_light_vector  = vec3( normalize( light_position - eye_pos ) );
	v_view_vector   = vec3( normalize( -eye_pos ) );

	v_texcoord      = nv_texcoord;
	gl_Position     = matrix_mvp * vertex;
}
