// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
#ifndef NV_LUA_GLM_HH
#define NV_LUA_GLM_HH

#include <new>
#include <nv/common.hh>
#include <nv/math.hh>
#include <nv/lib/lua.hh>
#include <nv/lua/lua_values.hh>

void nlua_register_glm( lua_State* L );

template< typename T > inline const char* nlua_metatable_name() { static_assert(sizeof(T) == 0, "Type not implemented!"); return NULL; }

template< typename T >
bool nlua_is_vec( lua_State* L, int index )
{
	return luaL_testudata( L, index, nlua_metatable_name<T>() ) != 0;
}

template< typename T >
T nlua_to_vec( lua_State* L, int index )
{
	return *(T*)luaL_checkudata( L, index, nlua_metatable_name<T>() );
}

template< typename T >
T* nlua_to_pvec( lua_State* L, int index )
{
	return (T*)luaL_checkudata( L, index, nlua_metatable_name<T>() );
}

template< typename T >
void nlua_push_vec( lua_State* L, const T& v )
{
	new (lua_newuserdata(L, sizeof(T))) T(v);
	luaL_setmetatable( L, nlua_metatable_name<T>() );
}

template<> inline const char* nlua_metatable_name< nv::ivec2 >() { return "ivec2"; }
template<> inline const char* nlua_metatable_name< nv::ivec3 >() { return "ivec3"; }
template<> inline const char* nlua_metatable_name< nv::ivec4 >() { return "ivec4"; }
template<> inline const char* nlua_metatable_name< nv::vec2  >() { return "vec2"; }
template<> inline const char* nlua_metatable_name< nv::vec3  >() { return "vec3"; }
template<> inline const char* nlua_metatable_name< nv::vec4  >() { return "vec4"; }

namespace nv
{
	namespace lua
	{

		template< typename T >
		struct pass_traits< glm::detail::tvec2<T> >
		{
			typedef glm::detail::tvec2<T> value_type;
			static void push( lua_State *L, const value_type& p ) { nlua_push_vec< value_type >( L, p ); }
			static void pop( lua_State *L, value_type& p ) { p = nlua_to_vec< value_type >( L, -1 ); lua_pop( L, 1 ); }
		};

		template< typename T >
		struct pass_traits< glm::detail::tvec3<T> >
		{
			typedef glm::detail::tvec3<T> value_type;
			static void push( lua_State *L, const value_type& p ) { nlua_push_vec< value_type >( L, p ); }
			static void pop( lua_State *L, value_type& p ) { p = nlua_to_vec< value_type >( L, -1 ); lua_pop( L, 1 ); }
		};

		template< typename T >
		struct pass_traits< glm::detail::tvec4<T> >
		{
			typedef glm::detail::tvec4<T> value_type;
			static void push( lua_State *L, const value_type& p ) { nlua_push_vec< value_type >( L, p ); }
			static void pop( lua_State *L, value_type& p ) { p = nlua_to_vec< value_type >( L, -1 ); lua_pop( L, 1 ); }
		};
	}

}


#endif // NV_LUA_GLM_HH
