-- Error handling if user didn't provide any action/target
-- for the build
if _ACTION == nil then
	print "Error! You must specify target build"
	print "Example: ./premake4 gmake"
	print "    This will create makefiles for Linux"
	print ""
	print "Aborting!"
	print ""
	return
end

solution "nv"
	configurations { "debug", "release" }

	-- For starters, check the target build.
	-- If this is a gmake build we must add these
	-- flags to enable C++11 support.
	if _ACTION == "gmake" then
		buildoptions "-std=c++11"
	end

	targetdir "bin"
	flags { "ExtraWarnings", "NoPCH" }
	language "C++"

   	configuration "debug"
		defines { "DEBUG" }
		flags { "Symbols" }
		targetdir "bin"
		objdir (_ACTION.."/debug")

	configuration "release"
		defines { "NDEBUG" }
		flags { "Optimize" }
		targetdir "bin"
		objdir (_ACTION.."/release")

	dofile("nv.lua")
	
newaction {
	trigger     = "doc",
	description = "Run doxygen",
	execute     = function ()
		os.execute("doxygen")
	end
}

if _ACTION == "clean" then
	for action in premake.action.each() do
		os.rmdir(action.trigger)
	end
end

