// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
#ifndef NV_LUA_AREA_HH
#define NV_LUA_AREA_HH

#include <nv/common.hh>
#include <nv/position.hh>
#include <nv/lua/lua_glm.hh>
#include <nv/lib/lua.hh>

void nlua_register_area( lua_State* L );

bool nlua_is_area( lua_State* L, int index );
nv::rectangle nlua_to_area( lua_State* L, int index );
nv::rectangle* nlua_to_parea( lua_State* L, int index );
void nlua_push_area( lua_State* L, const nv::rectangle& v );

inline bool nlua_is_coord( lua_State* L, int index ) { return nlua_is_vec<nv::ivec2>( L, index ); }
inline nv::ivec2 nlua_to_coord( lua_State* L, int index ) { return nlua_to_vec<nv::ivec2>( L, index ); }
inline nv::ivec2* nlua_to_pcoord( lua_State* L, int index ) { return nlua_to_pvec<nv::ivec2>( L, index ); }
inline void nlua_push_coord( lua_State* L, const nv::ivec2& v ) { return nlua_push_vec<nv::ivec2>( L, v ); }

#endif // NV_LUA_AREA_HH
