// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/sdl.hh"

#if defined( NV_SDL_DYNAMIC )

#include "nv/library.hh"

#define NV_SDL_FUN( rtype, fname, fparams ) rtype (NV_SDL_APIENTRY *fname) fparams = nullptr;
#include <nv/lib/detail/sdl_functions.inc>
#undef NV_SDL_FUN

bool nv::load_sdl_library( const char* path )
{
	static nv::library sdl_library;
	if ( sdl_library.is_open() ) return true;
	sdl_library.open( path );
#	define NV_SDL_FUN( rtype, fname, fparams ) *(void **) (&fname) = sdl_library.get(#fname);
#	include <nv/lib/detail/sdl_functions.inc>
#	undef NV_SDL_FUN
	return true;
}
#endif
