// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/common.hh"
#include "nv/lib/gl.hh"

#if defined( NV_GL_DYNAMIC )

#include "nv/library.hh"

#if defined( NV_SDL_GL )
#	include "nv/lib/sdl12.hh"
#endif

#define NV_GL_FUN( rtype, fname, fparams ) rtype (NV_GL_APIENTRY *fname) fparams = nullptr;
#define NV_GL_FUN_EXT NV_GL_FUN
#include <nv/lib/detail/gl_functions.inc>
#undef NV_GL_FUN_EXT
#undef NV_GL_FUN

bool nv::load_gl_library( const char* path )
{
#if defined( NV_SDL_GL )
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#else
	static nv::library gl_library;
	if ( gl_library.is_open() ) return true;
	gl_library.open( path );

	void * (NV_GL_APIENTRY *ext_loader) (const char* proc) = nullptr;
#	if NV_PLATFORM == NV_WINDOWS 
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
		*(void **) (&ext_loader) = gl_library.get("wglGetProcAddress");
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = ext_loader(#symbol);
#	elif NV_PLATFORM == NV_LINUX
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
		*(void **) (&ext_loader) = gl_library.get("glXGetProcAddress");
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = ext_loader(#symbol);
#	else
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
#	endif
#endif

#	define NV_GL_FUN( rtype, fname, fparams ) NV_GL_LOAD( fname )
#	define NV_GL_FUN_EXT( rtype, fname, fparams ) NV_GL_LOAD_EXT( fname )
#	include <nv/lib/detail/gl_functions.inc>
#	undef NV_GL_FUN_EXT
#	undef NV_GL_FUN

#	undef NV_GL_LOAD
#	undef NV_GL_LOAD_EXT
	return true;
}

#endif
