/* State manipulation */
NV_LUA_FUN( lua_State *,lua_newstate,(lua_Alloc f, void *ud) );
NV_LUA_FUN( void       ,lua_close,(lua_State *L) );
NV_LUA_FUN( lua_State *,lua_newthread,(lua_State *L) );
NV_LUA_FUN( lua_CFunction,lua_atpanic,(lua_State *L, lua_CFunction panicf) );
NV_LUA_FUN_52( const lua_Number *,lua_version,(lua_State *L) );

/* Basic stack manipulation */
NV_LUA_FUN_52( int  ,lua_absindex,(lua_State *L, int idx) );
NV_LUA_FUN( int  ,lua_gettop,(lua_State *L) );
NV_LUA_FUN( void ,lua_settop,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_pushvalue,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_remove,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_insert,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_replace,(lua_State *L, int idx) );
NV_LUA_FUN_52( void ,lua_copy,(lua_State *L, int fromidx, int toidx) );
NV_LUA_FUN( int  ,lua_checkstack,(lua_State *L, int sz) );
NV_LUA_FUN( void ,lua_xmove,(lua_State *from, lua_State *to, int n) );

/* Access functions (stack -> C) */
NV_LUA_FUN( int            ,lua_isnumber,(lua_State *L, int idx) );
NV_LUA_FUN( int            ,lua_isstring,(lua_State *L, int idx) );
NV_LUA_FUN( int            ,lua_iscfunction,(lua_State *L, int idx) );
NV_LUA_FUN( int            ,lua_isuserdata,(lua_State *L, int idx) );
NV_LUA_FUN( int            ,lua_type,(lua_State *L, int idx) );
NV_LUA_FUN( const char*    ,lua_typename,(lua_State *L, int tp) );

NV_LUA_FUN_52( lua_Number     ,lua_tonumberx,(lua_State *L, int idx, int *isnum) );
NV_LUA_FUN_52( lua_Integer    ,lua_tointegerx,(lua_State *L, int idx, int *isnum) );
NV_LUA_FUN_52( lua_Unsigned   ,lua_tounsignedx,(lua_State *L, int idx, int *isnum) );
NV_LUA_FUN_51( lua_Number     ,lua_tonumber,(lua_State *L, int idx) );
NV_LUA_FUN_51( lua_Integer    ,lua_tointeger,(lua_State *L, int idx) );
NV_LUA_FUN( int            ,lua_toboolean,(lua_State *L, int idx) );
NV_LUA_FUN( const char*    ,lua_tolstring,(lua_State *L, int idx, size_t *len) );
NV_LUA_FUN_52( size_t         ,lua_rawlen,(lua_State *L, int idx) );
NV_LUA_FUN_51( size_t         ,lua_objlen,(lua_State *L, int idx) );
NV_LUA_FUN( lua_CFunction  ,lua_tocfunction,(lua_State *L, int idx) );
NV_LUA_FUN( void*          ,lua_touserdata,(lua_State *L, int idx) );
NV_LUA_FUN( lua_State*     ,lua_tothread,(lua_State *L, int idx) );
NV_LUA_FUN( const void*    ,lua_topointer,(lua_State *L, int idx) );

/* Comparison and arithmetic functions */
NV_LUA_FUN_52( void ,lua_arith,(lua_State *L, int op) );
NV_LUA_FUN( int  ,lua_rawequal,(lua_State *L, int idx1, int idx2) );
NV_LUA_FUN_52( int,lua_compare,(lua_State *L, int idx1, int idx2, int op) );
NV_LUA_FUN_51( int,lua_equal, (lua_State *L, int idx1, int idx2) );
NV_LUA_FUN_51( int,lua_lessthan, (lua_State *L, int idx1, int idx2) );

/* Push functions (C -> stack) */
NV_LUA_FUN( void        ,lua_pushnil,(lua_State *L) );
NV_LUA_FUN( void        ,lua_pushnumber,(lua_State *L, lua_Number n) );
NV_LUA_FUN( void        ,lua_pushinteger,(lua_State *L, lua_Integer n) );
NV_LUA_FUN_52( void        ,lua_pushunsigned,(lua_State *L, lua_Unsigned n) );
NV_LUA_FUN_52( const char* ,lua_pushlstring,(lua_State *L, const char *s, size_t l) );
NV_LUA_FUN_52( const char* ,lua_pushstring,(lua_State *L, const char *s) );
NV_LUA_FUN_51( void,lua_pushlstring,(lua_State *L, const char *s, size_t l) );
NV_LUA_FUN_51( void,lua_pushstring,(lua_State *L, const char *s) );
NV_LUA_FUN( const char* ,lua_pushvfstring,(lua_State *L, const char *fmt,
                                                      va_list argp) );
NV_LUA_FUN( const char *,lua_pushfstring,(lua_State *L, const char *fmt, ...) );
NV_LUA_FUN( void ,lua_pushcclosure,(lua_State *L, lua_CFunction fn, int n) );
NV_LUA_FUN( void ,lua_pushboolean,(lua_State *L, int b) );
NV_LUA_FUN( void ,lua_pushlightuserdata,(lua_State *L, void *p) );
NV_LUA_FUN( int  ,lua_pushthread,(lua_State *L) );

/* Get functions (Lua -> stack) */
NV_LUA_FUN_52( void ,lua_getglobal,(lua_State *L, const char *var) );
NV_LUA_FUN( void ,lua_gettable,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_getfield,(lua_State *L, int idx, const char *k) );
NV_LUA_FUN( void ,lua_rawget,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_rawgeti,(lua_State *L, int idx, int n) );
NV_LUA_FUN_52( void ,lua_rawgetp,(lua_State *L, int idx, const void *p) );
NV_LUA_FUN( void ,lua_createtable,(lua_State *L, int narr, int nrec) );
NV_LUA_FUN( void*,lua_newuserdata,(lua_State *L, size_t sz) );
NV_LUA_FUN( int  ,lua_getmetatable,(lua_State *L, int objindex) );
NV_LUA_FUN_52( void ,lua_getuservalue,(lua_State *L, int idx) );
NV_LUA_FUN_51( void ,lua_getfenv,(lua_State *L, int idx) );

/* Set functions (stack -> Lua) */
NV_LUA_FUN_52( void ,lua_setglobal,(lua_State *L, const char *var) );
NV_LUA_FUN( void ,lua_settable,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_setfield,(lua_State *L, int idx, const char *k) );
NV_LUA_FUN( void ,lua_rawset,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_rawseti,(lua_State *L, int idx, int n) );
NV_LUA_FUN_52( void ,lua_rawsetp,(lua_State *L, int idx, const void *p) );
NV_LUA_FUN( int  ,lua_setmetatable,(lua_State *L, int objindex) );
NV_LUA_FUN_52( void ,lua_setuservalue,(lua_State *L, int idx) );
NV_LUA_FUN_51( void ,lua_setfenv,(lua_State *L, int idx) );

/* 'load' and 'call' functions (load and run Lua code) */
NV_LUA_FUN_52( void ,lua_callk,(lua_State *L, int nargs, int nresults, int ctx, lua_CFunction k) );
NV_LUA_FUN_52( int  ,lua_pcallk,(lua_State *L, int nargs, int nresults, int errfunc, int ctx, lua_CFunction k) );
NV_LUA_FUN_51( void ,lua_call,(lua_State *L, int nargs, int nresults) );
NV_LUA_FUN_51( int  ,lua_pcall,(lua_State *L, int nargs, int nresults, int errfunc) );
NV_LUA_FUN_51( int  ,lua_cpcall,(lua_State *L, lua_CFunction func, void *ud) );
NV_LUA_FUN_52( int  ,lua_getctx,(lua_State *L, int *ctx) );
NV_LUA_FUN_52( int  ,lua_load,(lua_State *L, lua_Reader reader, void *dt, const char *chunkname, const char *mode) );
NV_LUA_FUN_51( int  ,lua_load,(lua_State *L, lua_Reader reader, void *dt, const char *chunkname) );
NV_LUA_FUN( int  ,lua_dump,(lua_State *L, lua_Writer writer, void *data) );

/* Coroutine functions */
NV_LUA_FUN_52( int ,lua_yieldk,(lua_State *L, int nresults, int ctx, lua_CFunction k) );
NV_LUA_FUN_51( int ,lua_yield,(lua_State *L, int nresults) );
NV_LUA_FUN_52( int ,lua_resume,(lua_State *L, lua_State *from, int narg) );
NV_LUA_FUN_51( int ,lua_resume,(lua_State *L, int narg) );
NV_LUA_FUN( int ,lua_status,(lua_State *L) );

/* Garbage-collection function and options */
NV_LUA_FUN( int,lua_gc,(lua_State *L, int what, int data) );

/* Miscellaneous functions */
NV_LUA_FUN( int  ,lua_error,(lua_State *L) );
NV_LUA_FUN( int  ,lua_next,(lua_State *L, int idx) );
NV_LUA_FUN( void ,lua_concat,(lua_State *L, int n) );
NV_LUA_FUN_52( void ,lua_len   ,(lua_State *L, int idx) );
NV_LUA_FUN( lua_Alloc,lua_getallocf,(lua_State *L, void **ud) );
NV_LUA_FUN( void     ,lua_setallocf,(lua_State *L, lua_Alloc f, void *ud) );

/* Debug API */
NV_LUA_FUN( int,lua_getstack,(lua_State *L, int level, lua_Debug *ar) );
NV_LUA_FUN( int,lua_getinfo,(lua_State *L, const char *what, lua_Debug *ar) );
NV_LUA_FUN( const char *,lua_getlocal,(lua_State *L, const lua_Debug *ar, int n) );
NV_LUA_FUN( const char *,lua_setlocal,(lua_State *L, const lua_Debug *ar, int n) );
NV_LUA_FUN( const char *,lua_getupvalue,(lua_State *L, int funcindex, int n) );
NV_LUA_FUN( const char *,lua_setupvalue,(lua_State *L, int funcindex, int n) );
NV_LUA_FUN_52( void *,lua_upvalueid,(lua_State *L, int fidx, int n) );
NV_LUA_FUN_52( void  ,lua_upvaluejoin,(lua_State *L, int fidx1, int n1, int fidx2, int n2) );
NV_LUA_FUN( int,lua_sethook,(lua_State *L, lua_Hook func, int mask, int count) );
NV_LUA_FUN( lua_Hook,lua_gethook,(lua_State *L) );
NV_LUA_FUN( int,lua_gethookmask,(lua_State *L) );
NV_LUA_FUN( int,lua_gethookcount,(lua_State *L) );

/* buffer API */
NV_LUA_FUN( void,luaL_buffinit, (lua_State *L, luaL_Buffer *B) );
NV_LUA_FUN_51( char *,luaL_prepbuffer,(luaL_Buffer *B) );
NV_LUA_FUN_52( char *,luaL_prepbuffsize,(luaL_Buffer *B, size_t sz) );
NV_LUA_FUN( void,luaL_addlstring,(luaL_Buffer *B, const char *s, size_t l) );
NV_LUA_FUN( void,luaL_addstring,(luaL_Buffer *B, const char *s) );
NV_LUA_FUN( void,luaL_addvalue,(luaL_Buffer *B) );
NV_LUA_FUN( void,luaL_pushresult,(luaL_Buffer *B) );	
NV_LUA_FUN_52( void,luaL_pushresultsize,(luaL_Buffer *B, size_t sz) );
NV_LUA_FUN_52( char *,luaL_buffinitsize,(lua_State *L, luaL_Buffer *B, size_t sz) );

/* lualib API */
NV_LUA_FUN( int,luaopen_base,(lua_State *L) );
NV_LUA_FUN( int,luaopen_table,(lua_State *L) );
NV_LUA_FUN( int,luaopen_io,(lua_State *L) );
NV_LUA_FUN( int,luaopen_os,(lua_State *L) );
NV_LUA_FUN( int,luaopen_string,(lua_State *L) );
NV_LUA_FUN( int,luaopen_math,(lua_State *L) );
NV_LUA_FUN( int,luaopen_debug,(lua_State *L) );
NV_LUA_FUN( int,luaopen_package,(lua_State *L) );
NV_LUA_FUN( int,luaL_openlibs,(lua_State *L) );
NV_LUA_FUN_52( int,luaopen_coroutine,(lua_State *L) );
NV_LUA_FUN_52( int,luaopen_bit32,(lua_State *L) );

/* lauxlib API */
NV_LUA_FUN_52( void  ,luaL_checkversion_,(lua_State *L, lua_Number ver) );
NV_LUA_FUN_52( const char *,luaL_tolstring,(lua_State *L, int idx, size_t *len) );
NV_LUA_FUN_52( lua_Unsigned ,luaL_checkunsigned,(lua_State *L, int numArg) );
NV_LUA_FUN_52( lua_Unsigned ,luaL_optunsigned,(lua_State *L, int numArg, lua_Unsigned def) );
NV_LUA_FUN_52( void  ,luaL_setmetatable,(lua_State *L, const char *tname) );
NV_LUA_FUN_52( void *,luaL_testudata,(lua_State *L, int ud, const char *tname) );
NV_LUA_FUN_52( int ,luaL_fileresult,(lua_State *L, int stat, const char *fname) );
NV_LUA_FUN_52( int ,luaL_execresult,(lua_State *L, int stat) );
NV_LUA_FUN_51( void  ,luaL_register,(lua_State *L, const char *libname,	const luaL_Reg *l) );
NV_LUA_FUN_51( void  ,luaL_typerror,(lua_State *L, int narg, const char *tname) );
NV_LUA_FUN( int ,luaL_getmetafield,(lua_State *L, int obj, const char *e) );
NV_LUA_FUN( int ,luaL_callmeta,(lua_State *L, int obj, const char *e) );
NV_LUA_FUN( int ,luaL_argerror,(lua_State *L, int numarg, const char *extramsg) );
NV_LUA_FUN( const char *,luaL_checklstring,(lua_State *L, int numArg, size_t *l) );
NV_LUA_FUN( const char *,luaL_optlstring,(lua_State *L, int numArg, const char *def, size_t *l) );
NV_LUA_FUN( lua_Number ,luaL_checknumber,(lua_State *L, int numArg) );
NV_LUA_FUN( lua_Number ,luaL_optnumber,(lua_State *L, int nArg, lua_Number def) );
NV_LUA_FUN( lua_Integer ,luaL_checkinteger,(lua_State *L, int numArg) );
NV_LUA_FUN( lua_Integer ,luaL_optinteger,(lua_State *L, int nArg, lua_Integer def) );
NV_LUA_FUN( void ,luaL_checkstack,(lua_State *L, int sz, const char *msg) );
NV_LUA_FUN( void ,luaL_checktype,(lua_State *L, int narg, int t) );
NV_LUA_FUN( void ,luaL_checkany,(lua_State *L, int narg) );
NV_LUA_FUN( int   ,luaL_newmetatable,(lua_State *L, const char *tname) );
NV_LUA_FUN( void *,luaL_checkudata,(lua_State *L, int ud, const char *tname) );
NV_LUA_FUN( void ,luaL_where,(lua_State *L, int lvl) );
NV_LUA_FUN( int ,luaL_error,(lua_State *L, const char *fmt, ...) );
NV_LUA_FUN( int ,luaL_checkoption,(lua_State *L, int narg, const char *def, const char *const lst[]) );

NV_LUA_FUN_52( int ,luaL_loadfilex,(lua_State *L, const char *filename, const char *mode) );
NV_LUA_FUN_51( int ,luaL_loadfile,(lua_State *L, const char *filename) );
NV_LUA_FUN_52( int ,luaL_loadbufferx,(lua_State *L, const char *buff, size_t sz, const char *name, const char *mode) );
NV_LUA_FUN_51( int ,luaL_loadbuffer,(lua_State *L, const char *buff, size_t sz, const char *name ) );
NV_LUA_FUN_52( int ,luaL_len,(lua_State *L, int idx) );
NV_LUA_FUN_51( const char *,luaL_findtable, (lua_State *L, int idx, const char *fname, int szhint) );
NV_LUA_FUN_52( void ,luaL_setfuncs,(lua_State *L, const luaL_Reg *l, int nup) );
NV_LUA_FUN_52( int ,luaL_getsubtable,(lua_State *L, int idx, const char *fname) );
NV_LUA_FUN_52( void ,luaL_traceback,(lua_State *L, lua_State *L1, const char *msg, int level) );
NV_LUA_FUN_52( void ,luaL_requiref,(lua_State *L, const char *modname, lua_CFunction openf, int glb) );
NV_LUA_FUN( int ,luaL_ref,(lua_State *L, int t) );
NV_LUA_FUN( void ,luaL_unref,(lua_State *L, int t, int ref) );
NV_LUA_FUN( int ,luaL_loadstring,(lua_State *L, const char *s) );
NV_LUA_FUN( lua_State *,luaL_newstate, (void) );
NV_LUA_FUN( const char *,luaL_gsub,(lua_State *L, const char *s, const char *p, const char *r) );
