// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file md3_loader.hh
 * @author Kornel Kisielewicz
 * @brief md3 loader
 */

#ifndef NV_MD3_LOADER_HH
#define NV_MD3_LOADER_HH

#include <unordered_map>
#include <vector>
#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{
	struct md3_tag
	{
		std::string name;
		mat4 transform;
	};

	class md3_loader : public mesh_loader
	{
	public:
		md3_loader();
		virtual ~md3_loader();
		virtual bool load( stream& source );
		virtual size_t get_size() { return m_size; }
		virtual mesh* release_mesh();
		virtual mesh* get_frame( sint32 frame );
		virtual const md3_tag* get_tag( const std::string& name ) const;
		virtual mat4 get_tag( sint32 frame, const std::string& name ) const;
		void load_positions( std::vector<vec3>& p, sint32 frame =-1 );
		void load_normals( std::vector<vec3>& n, sint32 frame =-1 );
		void load_texcoords( std::vector<vec2>& t );
		void load_indicies( std::vector<uint16>& idx );
	private:
		void* m_md3;
		std::unordered_map< std::string, md3_tag > m_tags;
		std::size_t m_size;
	};

}

#endif // NV_OBJ_LOADER_HH
