// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
//
// TODO: fix behavior for exact fits (1024^2 atlas with border 0 only holds 9 256^2 images...)

#ifndef NV_TEXTURE_ATLAS_HH
#define NV_TEXTURE_ATLAS_HH

#include <nv/common.hh>
#include <nv/math.hh>
#include <nv/gfx/image.hh>
#include <vector>

namespace nv
{

	class texture_atlas : public image
	{
	public:
		texture_atlas( ivec2 size, size_t depth, size_t border = 1 );
		region get_region( ivec2 size );
		void clear();
		size_t get_used() const { return m_used; }
	protected:
		int fit( size_t index, ivec2 size );
		void merge();
	private:
		size_t  m_used;
		std::vector<ivec3> m_nodes;
	};

}

#endif // NV_TEXTURE_ATLAS_HH

