// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_IMAGE_HH
#define NV_IMAGE_HH

#include <nv/common.hh>
#include <glm/glm.hpp>

namespace nv
{
	struct region
	{
		glm::ivec2 pos;
		glm::ivec2 size;

		region() : pos(0,0), size(0,0) {}
		region( glm::ivec2 pos, glm::ivec2 size ) : pos(pos), size(size) {}
	};

	class image
	{
	public:
		image( glm::ivec2 size, size_t depth );
		void clear();
		void fill( uint8 value );
		void set_region( region r, const uint8 * data, size_t stride = 0 );
		~image();
		const uint8 * get_data() const { return m_data; }
		const glm::ivec2 get_size() const { return m_size; }
		const size_t get_depth() const { return m_depth; }
	protected:
		glm::ivec2 m_size;
		size_t     m_depth;
		uint8*     m_data;
	};

}

#endif // NV_IMAGE_HH
