#version 120

attribute vec3 position;
attribute vec2 texcoord;
attribute vec3 normal;

varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
varying vec2 v_texcoord;

uniform mat4 matrix_mvp;
uniform mat4 nv_m_modelview;
uniform mat4 nv_m_projection;
uniform mat3 nv_m_normal;
uniform vec3 light_position;

void main(void) {
	vec4 vertex     = vec4( position, 1.0 );
	vec3 eye_pos    = vec3( nv_m_modelview * vertex );
	v_normal        = normalize( nv_m_normal * normal );
	v_light_vector  = vec3( normalize( light_position - eye_pos ) );
	v_view_vector   = vec3( normalize( -eye_pos ) );

	v_texcoord      = texcoord;
	gl_Position     = matrix_mvp * vertex;
}
