#version 120

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform vec4 light_diffuse;
uniform vec4 light_specular;
uniform vec3 custom_color_1;
uniform vec3 custom_color_2;

varying vec2 v_texcoord;
varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
 
void main(void) {
	vec3 nnormal         = normalize( v_normal );
	vec3 nlight_vector   = normalize( v_light_vector );
	vec3 nview_vector    = normalize( v_view_vector );
	vec3 nreflect_vector = reflect( -nlight_vector, nnormal );

	float specular_value = clamp( dot( nreflect_vector, nview_vector ), 0.0, 1.0 );
	specular_value       = pow( specular_value, 6.0 );
	float diffuse_value  = max( dot( nlight_vector, nnormal ), 0.0 );

	vec3 diff_texel      = vec3( texture2D( diffuse, v_texcoord ) );	
	vec4 spec_texel      = texture2D( specular, v_texcoord );
	
	float specular_amount = spec_texel.x;
	float diffuse_amount  = 1.0 - specular_amount;

	vec3 custom_color     = (custom_color_1 * (1.0-spec_texel.z) + custom_color_2 * (1.0-spec_texel.a))*0.4;

	float final_specular = specular_amount * specular_value;
	float final_diffuse  = diffuse_amount * diffuse_value;

	vec3 self_ilum_color = spec_texel.y * diff_texel;
	vec3 diffuse_color   = light_diffuse.xyz * final_diffuse * clamp( diff_texel + custom_color, 0.0, 1.0 );
	vec3 specular_color  = light_specular.xyz * final_specular;

	gl_FragColor = vec4( max( self_ilum_color, diffuse_color + specular_color), 1.0 );
}