#version 120
attribute vec3 position;
attribute vec2 texcoord;
attribute vec3 normal;
varying vec2 f_texcoord;
varying float f_diffuse_value;
uniform mat4 matrix_mvp;
uniform vec3 light;

void main(void) {
	vec3 vnormal    = normalize(normal);
	vec3 vlight     = normalize(light - position);
	float diffuse   = max(dot(vlight, vnormal), 0.0);
	f_diffuse_value = diffuse;
	f_texcoord      = texcoord;
	gl_Position     = matrix_mvp * vec4(position, 1.0);
}
